/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.PersistenceUnitInfoBean;
import io.helidon.integrations.jta.jdbc.JtaDataSource;
import io.helidon.integrations.jta.jdbc.XADataSourceWrappingDataSource;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.inject.Inject;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionScoped;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

@ApplicationScoped
class JtaDataSourceProvider
implements PersistenceUnitInfoBean.DataSourceProvider {
    private static final String NULL_DATASOURCE_NAME = "\u0000";
    private final Instance<Object> objects;
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry tsr;
    private final ConcurrentMap<String, DataSource> dataSourcesByName;

    @Deprecated
    JtaDataSourceProvider() {
        this.objects = null;
        this.transactionManager = null;
        this.tsr = null;
        this.dataSourcesByName = null;
    }

    @Inject
    JtaDataSourceProvider(Instance<Object> objects, TransactionManager transactionManager, TransactionSynchronizationRegistry tsr) {
        this.objects = Objects.requireNonNull(objects);
        this.transactionManager = Objects.requireNonNull(transactionManager);
        this.tsr = Objects.requireNonNull(tsr);
        this.dataSourcesByName = new ConcurrentHashMap<String, DataSource>();
    }

    @Override
    public DataSource getDataSource(boolean jta, boolean useDefaultJta, String dataSourceName) {
        DataSource returnValue;
        if (jta) {
            try {
                if (dataSourceName == null) {
                    if (useDefaultJta) {
                        Instance xaDataSources = this.objects.select(XADataSource.class, new Annotation[0]);
                        if (xaDataSources.isUnsatisfied()) {
                            returnValue = this.convert((DataSource)this.objects.select(DataSource.class, new Annotation[0]).get(), jta, null);
                        }
                        returnValue = this.convert((XADataSource)xaDataSources.get(), jta, null);
                    }
                    returnValue = null;
                }
                NamedLiteral named = NamedLiteral.of((String)dataSourceName);
                Instance xaDataSources = this.objects.select(XADataSource.class, new Annotation[]{named});
                if (xaDataSources.isUnsatisfied()) {
                    returnValue = this.convert((DataSource)this.objects.select(DataSource.class, new Annotation[]{named}).get(), jta, dataSourceName);
                }
                returnValue = this.convert((XADataSource)xaDataSources.get(), jta, dataSourceName);
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException(sqlException.getMessage(), sqlException);
            }
        } else {
            returnValue = dataSourceName == null ? null : (DataSource)this.objects.select(DataSource.class, new Annotation[]{NamedLiteral.of((String)dataSourceName)}).get();
        }
        return returnValue;
    }

    private DataSource convert(XADataSource xaDataSource, boolean jta, String dataSourceName) throws SQLException {
        Objects.requireNonNull(xaDataSource);
        DataSource returnValue = this.dataSourcesByName.computeIfAbsent(dataSourceName == null ? NULL_DATASOURCE_NAME : dataSourceName, ignoredKey -> new XADataSourceWrappingDataSource(xaDataSource, this::enlistResource));
        return returnValue;
    }

    private boolean activeTransaction() {
        try {
            return this.transactionManager.getStatus() == 0;
        }
        catch (SystemException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void enlistResource(XAResource resource) {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction != null && transaction.getStatus() == 0) {
                transaction.enlistResource(resource);
            }
        }
        catch (RollbackException | SystemException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private DataSource convert(DataSource dataSource, boolean jta, String dataSourceName) throws SQLException {
        DataSource returnValue;
        if (!jta || dataSource == null || dataSource instanceof JtaDataSource) {
            returnValue = dataSource;
        } else if (dataSource instanceof XADataSource) {
            returnValue = this.convert((XADataSource)((Object)dataSource), jta, dataSourceName);
        } else {
            returnValue = this.dataSourcesByName.computeIfAbsent(dataSourceName == null ? NULL_DATASOURCE_NAME : dataSourceName, k -> new JtaDataSource(dataSource, this::activeTransaction));
            this.registerSynchronizationIfTransactionIsActive(returnValue);
        }
        return returnValue;
    }

    private void registerSynchronizationIfTransactionIsActive(Object dataSource) {
        if (dataSource instanceof Synchronization && this.tsr.getTransactionStatus() == 0) {
            this.tsr.registerInterposedSynchronization((Synchronization)dataSource);
        }
    }

    private void whenTransactionStarts(@Observes @Initialized(value=TransactionScoped.class) Object event) {
        this.dataSourcesByName.forEach((ignoredKey, dataSource) -> this.registerSynchronizationIfTransactionIsActive(dataSource));
    }

    private void whenApplicationTerminates(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        this.dataSourcesByName.clear();
    }
}

