/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.TransactionSupport;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionScoped;
import java.util.Objects;

@ApplicationScoped
class JtaTransactionSupport
implements TransactionSupport {
    private final BeanManager beanManager;
    private Context transactionScopedContext;
    private final TransactionManager transactionManager;

    @Deprecated
    JtaTransactionSupport() {
        this.beanManager = null;
        this.transactionManager = null;
    }

    @Inject
    private JtaTransactionSupport(BeanManager beanManager, TransactionManager transactionManager) {
        this.beanManager = Objects.requireNonNull(beanManager);
        this.transactionManager = Objects.requireNonNull(transactionManager);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Context getContext() {
        Context returnValue;
        if (this.transactionScopedContext == null) {
            try {
                this.transactionScopedContext = this.beanManager.getContext(TransactionScoped.class);
            }
            catch (ContextNotActiveException contextNotActiveException) {
                this.transactionScopedContext = null;
            }
            finally {
                returnValue = this.transactionScopedContext;
            }
        } else {
            returnValue = this.transactionScopedContext.isActive() ? this.transactionScopedContext : null;
        }
        return returnValue;
    }

    @Override
    public int getStatus() {
        try {
            return this.transactionManager.getStatus();
        }
        catch (SystemException systemException) {
            throw new IllegalStateException(systemException.getMessage(), systemException);
        }
    }
}

