/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.ClearingQuery;
import io.helidon.integrations.cdi.jpa.ClearingStoredProcedureQuery;
import io.helidon.integrations.cdi.jpa.ClearingTypedQuery;
import io.helidon.integrations.cdi.jpa.DelegatingEntityManager;
import io.helidon.integrations.cdi.jpa.EntityManagers;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;

@Vetoed
class NonTransactionalEntityManager
extends DelegatingEntityManager {
    NonTransactionalEntityManager(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers) {
        super(EntityManagers.createContainerManagedEntityManager(instance, suppliedQualifiers));
    }

    @Override
    protected EntityManager acquireDelegate() {
        throw new PersistenceException();
    }

    @Override
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return new ClearingTypedQuery<T>(this, super.createNamedQuery(name, resultClass));
    }

    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new ClearingTypedQuery<T>(this, super.createQuery(criteriaQuery));
    }

    @Override
    public <T> TypedQuery<T> createQuery(String jpql, Class<T> resultClass) {
        return new ClearingTypedQuery<T>(this, super.createQuery(jpql, resultClass));
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        T returnValue = super.find(entityClass, primaryKey, properties);
        this.clear();
        return returnValue;
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        T returnValue = super.find(entityClass, primaryKey);
        this.clear();
        return returnValue;
    }

    @Override
    public Query createNamedQuery(String name) {
        return new ClearingQuery(this, super.createNamedQuery(name));
    }

    @Override
    public Query createNativeQuery(String sql, Class resultClass) {
        return new ClearingQuery(this, super.createNativeQuery(sql, resultClass));
    }

    @Override
    public Query createNativeQuery(String sql, String resultSetMapping) {
        return new ClearingQuery(this, super.createNativeQuery(sql, resultSetMapping));
    }

    @Override
    public Query createNativeQuery(String sql) {
        return new ClearingQuery(this, super.createNativeQuery(sql));
    }

    @Override
    public Query createQuery(String jpql) {
        return new ClearingQuery(this, super.createQuery(jpql));
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        T returnValue = super.getReference(entityClass, primaryKey);
        this.clear();
        return returnValue;
    }

    @Override
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return new ClearingStoredProcedureQuery(this, super.createNamedStoredProcedureQuery(name));
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return new ClearingStoredProcedureQuery(this, super.createStoredProcedureQuery(procedureName));
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return new ClearingStoredProcedureQuery(this, super.createStoredProcedureQuery(procedureName, resultClasses));
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return new ClearingStoredProcedureQuery(this, super.createStoredProcedureQuery(procedureName, resultSetMappings));
    }

    @Override
    public boolean isJoinedToTransaction() {
        return false;
    }

    @Override
    public void joinTransaction() {
        throw new TransactionRequiredException();
    }

    @Override
    public void persist(Object entity) {
        throw new TransactionRequiredException();
    }

    @Override
    public <T> T merge(T entity) {
        throw new TransactionRequiredException();
    }

    @Override
    public void remove(Object entity) {
        throw new TransactionRequiredException();
    }

    @Override
    public void refresh(Object entity) {
        throw new TransactionRequiredException();
    }

    @Override
    public void refresh(Object entity, Map<String, Object> properties) {
        throw new TransactionRequiredException();
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode) {
        throw new TransactionRequiredException();
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        throw new TransactionRequiredException();
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        if (lockMode != null && !lockMode.equals((Object)LockModeType.NONE)) {
            throw new TransactionRequiredException();
        }
        T returnValue = super.find(entityClass, primaryKey, lockMode);
        this.clear();
        return returnValue;
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        if (lockMode != null && !lockMode.equals((Object)LockModeType.NONE)) {
            throw new TransactionRequiredException();
        }
        T returnValue = super.find(entityClass, primaryKey, lockMode, properties);
        this.clear();
        return returnValue;
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        throw new TransactionRequiredException();
    }

    @Override
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        throw new TransactionRequiredException();
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        throw new TransactionRequiredException();
    }

    @Override
    public void flush() {
        throw new TransactionRequiredException();
    }
}

