/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.jaxb.Persistence;
import io.helidon.integrations.cdi.jpa.jaxb.PersistenceUnitCachingType;
import io.helidon.integrations.cdi.jpa.jaxb.PersistenceUnitTransactionType;
import io.helidon.integrations.cdi.jpa.jaxb.PersistenceUnitValidationModeType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class PersistenceUnitInfoBean
implements PersistenceUnitInfo {
    private final ClassLoader classLoader;
    private final ClassLoader originalClassLoader;
    private final boolean excludeUnlistedClasses;
    private final List<URL> jarFileUrls;
    private final Set<String> managedClassNames;
    private final List<String> managedClassNamesView;
    private final List<String> mappingFileNames;
    private final String jtaDataSourceName;
    private final String nonJtaDataSourceName;
    private final Supplier<? extends DataSourceProvider> dataSourceProviderSupplier;
    private DataSourceProvider dataSourceProvider;
    private final String persistenceProviderClassName;
    private final String persistenceUnitName;
    private final URL persistenceUnitRootUrl;
    private final String persistenceXMLSchemaVersion;
    private final Properties properties;
    private final SharedCacheMode sharedCacheMode;
    private final Consumer<? super ClassTransformer> classTransformerConsumer;
    private final Supplier<? extends ClassLoader> tempClassLoaderSupplier;
    private final jakarta.persistence.spi.PersistenceUnitTransactionType transactionType;
    private final ValidationMode validationMode;

    public PersistenceUnitInfoBean(String persistenceUnitName, URL persistenceUnitRootUrl, Collection<? extends String> managedClassNames, DataSourceProvider dataSourceProvider, Properties properties) {
        this(persistenceUnitName, persistenceUnitRootUrl, null, null, Thread.currentThread().getContextClassLoader(), null, null, managedClassNames != null && !managedClassNames.isEmpty(), null, managedClassNames, null, persistenceUnitName, null, dataSourceProvider, properties, SharedCacheMode.UNSPECIFIED, jakarta.persistence.spi.PersistenceUnitTransactionType.JTA, ValidationMode.AUTO);
    }

    public PersistenceUnitInfoBean(String persistenceUnitName, URL persistenceUnitRootUrl, Collection<? extends String> managedClassNames, Supplier<? extends DataSourceProvider> dataSourceProviderSupplier, Properties properties) {
        this(persistenceUnitName, persistenceUnitRootUrl, null, null, Thread.currentThread().getContextClassLoader(), null, null, managedClassNames != null && !managedClassNames.isEmpty(), null, managedClassNames, null, persistenceUnitName, null, dataSourceProviderSupplier, properties, SharedCacheMode.UNSPECIFIED, jakarta.persistence.spi.PersistenceUnitTransactionType.JTA, ValidationMode.AUTO);
    }

    public PersistenceUnitInfoBean(String persistenceUnitName, URL persistenceUnitRootUrl, String persistenceXMLSchemaVersion, String persistenceProviderClassName, ClassLoader classLoader, Supplier<? extends ClassLoader> tempClassLoaderSupplier, Consumer<? super ClassTransformer> classTransformerConsumer, boolean excludeUnlistedClasses, Collection<? extends URL> jarFileUrls, Collection<? extends String> managedClassNames, Collection<? extends String> mappingFileNames, String jtaDataSourceName, String nonJtaDataSourceName, DataSourceProvider dataSourceProvider, Properties properties, SharedCacheMode sharedCacheMode, jakarta.persistence.spi.PersistenceUnitTransactionType transactionType, ValidationMode validationMode) {
        this(persistenceUnitName, persistenceUnitRootUrl, persistenceXMLSchemaVersion, persistenceProviderClassName, classLoader, tempClassLoaderSupplier, classTransformerConsumer, excludeUnlistedClasses, jarFileUrls, managedClassNames, mappingFileNames, jtaDataSourceName, nonJtaDataSourceName, () -> dataSourceProvider, properties, sharedCacheMode, transactionType, validationMode);
    }

    public PersistenceUnitInfoBean(String persistenceUnitName, URL persistenceUnitRootUrl, String persistenceXMLSchemaVersion, String persistenceProviderClassName, ClassLoader classLoader, Supplier<? extends ClassLoader> tempClassLoaderSupplier, Consumer<? super ClassTransformer> classTransformerConsumer, boolean excludeUnlistedClasses, Collection<? extends URL> jarFileUrls, Collection<? extends String> managedClassNames, Collection<? extends String> mappingFileNames, String jtaDataSourceName, String nonJtaDataSourceName, Supplier<? extends DataSourceProvider> dataSourceProviderSupplier, Properties properties, SharedCacheMode sharedCacheMode, jakarta.persistence.spi.PersistenceUnitTransactionType transactionType, ValidationMode validationMode) {
        Objects.requireNonNull(persistenceUnitName);
        Objects.requireNonNull(persistenceUnitRootUrl);
        Objects.requireNonNull(dataSourceProviderSupplier);
        Objects.requireNonNull(transactionType);
        this.persistenceUnitName = persistenceUnitName;
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
        this.persistenceProviderClassName = persistenceProviderClassName;
        this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion == null ? "2.2" : persistenceXMLSchemaVersion;
        this.originalClassLoader = classLoader;
        this.classLoader = classLoader;
        this.tempClassLoaderSupplier = tempClassLoaderSupplier;
        this.classTransformerConsumer = classTransformerConsumer;
        this.excludeUnlistedClasses = excludeUnlistedClasses;
        this.jarFileUrls = jarFileUrls == null || jarFileUrls.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<URL>(jarFileUrls));
        this.managedClassNames = managedClassNames == null || managedClassNames.isEmpty() ? new LinkedHashSet<String>() : new LinkedHashSet<String>(managedClassNames);
        this.managedClassNamesView = new AbstractList<String>(){

            @Override
            public boolean isEmpty() {
                return PersistenceUnitInfoBean.this.managedClassNames.isEmpty();
            }

            @Override
            public int size() {
                return PersistenceUnitInfoBean.this.managedClassNames.size();
            }

            @Override
            public Iterator<String> iterator() {
                return PersistenceUnitInfoBean.this.managedClassNames.iterator();
            }

            @Override
            public String get(int index) {
                Iterator<String> iterator = this.iterator();
                assert (iterator != null);
                for (int i = 0; i < index; ++i) {
                    iterator.next();
                }
                return iterator.next();
            }
        };
        this.mappingFileNames = mappingFileNames == null || mappingFileNames.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(mappingFileNames));
        this.properties = properties == null ? new Properties() : properties;
        this.jtaDataSourceName = jtaDataSourceName == null || jtaDataSourceName.isEmpty() ? null : jtaDataSourceName;
        this.nonJtaDataSourceName = nonJtaDataSourceName;
        this.dataSourceProviderSupplier = dataSourceProviderSupplier;
        this.sharedCacheMode = sharedCacheMode == null ? SharedCacheMode.UNSPECIFIED : sharedCacheMode;
        this.transactionType = transactionType;
        this.validationMode = validationMode == null ? ValidationMode.AUTO : validationMode;
    }

    boolean addManagedClassName(String className) {
        return className != null && this.managedClassNames.add(className);
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNamesView;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public ClassLoader getNewTempClassLoader() {
        ClassLoader cl = null;
        if (this.tempClassLoaderSupplier != null) {
            cl = this.tempClassLoaderSupplier.get();
        }
        if (cl == null && (cl = this.originalClassLoader) == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.classTransformerConsumer != null) {
            this.classTransformerConsumer.accept((ClassTransformer)classTransformer);
        }
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public jakarta.persistence.spi.PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public final DataSource getJtaDataSource() {
        DataSourceProvider dataSourceProvider = this.dataSourceProvider;
        if (dataSourceProvider == null) {
            this.dataSourceProvider = dataSourceProvider = this.dataSourceProviderSupplier.get();
        }
        return dataSourceProvider.getDataSource(true, this.nonJtaDataSourceName == null, this.jtaDataSourceName);
    }

    public final DataSource getNonJtaDataSource() {
        DataSourceProvider dataSourceProvider = this.dataSourceProvider;
        if (dataSourceProvider == null) {
            this.dataSourceProvider = dataSourceProvider = this.dataSourceProviderSupplier.get();
        }
        return dataSourceProvider.getDataSource(false, false, this.nonJtaDataSourceName);
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public String toString() {
        return this.getPersistenceUnitName() + " (" + String.valueOf(this.getPersistenceUnitRootUrl()) + ")";
    }

    public static final PersistenceUnitInfoBean fromPersistenceUnit(Persistence.PersistenceUnit persistenceUnit, URL rootUrl, Map<? extends String, ? extends Set<? extends Class<?>>> unlistedClasses, DataSourceProvider dataSourceProvider) throws MalformedURLException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitInfoBean.fromPersistenceUnit(persistenceUnit, classLoader, () -> classLoader, rootUrl, unlistedClasses, () -> dataSourceProvider);
    }

    public static final PersistenceUnitInfoBean fromPersistenceUnit(Persistence.PersistenceUnit persistenceUnit, URL rootUrl, Map<? extends String, ? extends Set<? extends Class<?>>> unlistedClasses, Supplier<? extends DataSourceProvider> dataSourceProviderSupplier) throws MalformedURLException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitInfoBean.fromPersistenceUnit(persistenceUnit, classLoader, () -> classLoader, rootUrl, unlistedClasses, dataSourceProviderSupplier);
    }

    public static final PersistenceUnitInfoBean fromPersistenceUnit(Persistence.PersistenceUnit persistenceUnit, ClassLoader classLoader, Supplier<? extends ClassLoader> tempClassLoaderSupplier, URL rootUrl, Map<? extends String, ? extends Set<? extends Class<?>>> unlistedClasses, DataSourceProvider dataSourceProvider) throws MalformedURLException {
        return PersistenceUnitInfoBean.fromPersistenceUnit(persistenceUnit, classLoader, tempClassLoaderSupplier, rootUrl, unlistedClasses, () -> dataSourceProvider);
    }

    public static final PersistenceUnitInfoBean fromPersistenceUnit(Persistence.PersistenceUnit persistenceUnit, ClassLoader classLoader, Supplier<? extends ClassLoader> tempClassLoaderSupplier, URL rootUrl, Map<? extends String, ? extends Set<? extends Class<?>>> unlistedClasses, Supplier<? extends DataSourceProvider> dataSourceProviderSupplier) throws MalformedURLException {
        PersistenceUnitCachingType persistenceUnitCachingType;
        Boolean excludeUnlistedClasses;
        List<Persistence.PersistenceUnit.Properties.Property> propertyInstances;
        Objects.requireNonNull(persistenceUnit);
        Objects.requireNonNull(rootUrl);
        Objects.requireNonNull(dataSourceProviderSupplier);
        List<String> jarFiles = persistenceUnit.getJarFile();
        ArrayList<URL> jarFileUrls = new ArrayList<URL>();
        for (String jarFile : jarFiles) {
            if (jarFile == null) continue;
            jarFileUrls.add(PersistenceUnitInfoBean.createJarFileURL(rootUrl, jarFile));
        }
        List<String> mappingFiles = persistenceUnit.getMappingFile();
        Properties properties = new Properties();
        Persistence.PersistenceUnit.Properties persistenceUnitProperties = persistenceUnit.getProperties();
        if (persistenceUnitProperties != null && (propertyInstances = persistenceUnitProperties.getProperty()) != null && !propertyInstances.isEmpty()) {
            for (Persistence.PersistenceUnit.Properties.Property property : propertyInstances) {
                assert (property != null);
                properties.setProperty(property.getName(), property.getValue());
            }
        }
        List<String> managedClasses = persistenceUnit.getClazz();
        assert (managedClasses != null);
        String name = persistenceUnit.getName();
        if (name == null || name.isEmpty()) {
            name = "__DEFAULT__";
        }
        if (!(Boolean.TRUE.equals(excludeUnlistedClasses = persistenceUnit.isExcludeUnlistedClasses()) || unlistedClasses.isEmpty() || Boolean.TRUE.equals(persistenceUnit.isExcludeUnlistedClasses()))) {
            Set<Class<?>> myUnlistedClasses = unlistedClasses.get(name);
            if (myUnlistedClasses != null && !myUnlistedClasses.isEmpty()) {
                for (Class<?> unlistedClass : myUnlistedClasses) {
                    if (unlistedClass == null) continue;
                    managedClasses.add(unlistedClass.getName());
                }
            }
            if ((myUnlistedClasses = unlistedClasses.get("__DEFAULT__")) != null && !myUnlistedClasses.isEmpty()) {
                for (Class<?> unlistedClass : myUnlistedClasses) {
                    if (unlistedClass == null) continue;
                    managedClasses.add(unlistedClass.getName());
                }
            }
        }
        SharedCacheMode sharedCacheMode = (persistenceUnitCachingType = persistenceUnit.getSharedCacheMode()) == null ? SharedCacheMode.UNSPECIFIED : SharedCacheMode.valueOf((String)persistenceUnitCachingType.name());
        PersistenceUnitTransactionType persistenceUnitTransactionType = persistenceUnit.getTransactionType();
        jakarta.persistence.spi.PersistenceUnitTransactionType transactionType = persistenceUnitTransactionType == null ? jakarta.persistence.spi.PersistenceUnitTransactionType.JTA : jakarta.persistence.spi.PersistenceUnitTransactionType.valueOf((String)persistenceUnitTransactionType.name());
        PersistenceUnitValidationModeType validationModeType = persistenceUnit.getValidationMode();
        ValidationMode validationMode = validationModeType == null ? ValidationMode.AUTO : ValidationMode.valueOf((String)validationModeType.name());
        if (tempClassLoaderSupplier == null) {
            tempClassLoaderSupplier = () -> {
                if (classLoader instanceof URLClassLoader) {
                    return new URLClassLoader(((URLClassLoader)classLoader).getURLs());
                }
                return classLoader;
            };
        }
        PersistenceUnitInfoBean returnValue = new PersistenceUnitInfoBean(name, rootUrl, "2.2", persistenceUnit.getProvider(), classLoader, tempClassLoaderSupplier, null, excludeUnlistedClasses == null ? true : excludeUnlistedClasses, jarFileUrls, managedClasses, mappingFiles, persistenceUnit.getJtaDataSource(), persistenceUnit.getNonJtaDataSource(), dataSourceProviderSupplier, properties, sharedCacheMode, transactionType, validationMode);
        return returnValue;
    }

    private static URL createJarFileURL(URL persistenceUnitRootUrl, String jarFileUrlString) throws MalformedURLException {
        Objects.requireNonNull(persistenceUnitRootUrl);
        Objects.requireNonNull(jarFileUrlString);
        URL returnValue = new URL(persistenceUnitRootUrl, jarFileUrlString);
        return returnValue;
    }

    @FunctionalInterface
    public static interface DataSourceProvider {
        public DataSource getDataSource(boolean var1, boolean var2, String var3);
    }
}

