/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.jta.weld;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.weld.transaction.spi.TransactionServices;

public final class NarayanaTransactionServices
implements TransactionServices {
    private static final Logger LOGGER = Logger.getLogger(NarayanaTransactionServices.class.getName(), NarayanaTransactionServices.class.getPackage().getName() + ".Messages");

    @Deprecated
    public NarayanaTransactionServices() {
        String cn = NarayanaTransactionServices.class.getName();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "<init>");
            LOGGER.exiting(cn, "<init>");
        }
    }

    public UserTransaction getUserTransaction() {
        String cn = NarayanaTransactionServices.class.getName();
        String mn = "getUserTransaction";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "getUserTransaction");
        }
        Instance jtaEnvironmentBeans = CDI.current().select(JTAEnvironmentBean.class, new Annotation[0]);
        assert (jtaEnvironmentBeans != null);
        JTAEnvironmentBean jtaEnvironmentBean = jtaEnvironmentBeans.isUnsatisfied() ? jtaPropertyManager.getJTAEnvironmentBean() : (JTAEnvironmentBean)jtaEnvironmentBeans.get();
        assert (jtaEnvironmentBean != null);
        UserTransaction returnValue = jtaEnvironmentBean.getUserTransaction();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "getUserTransaction", returnValue);
        }
        return returnValue;
    }

    public boolean isTransactionActive() {
        boolean returnValue;
        String cn = NarayanaTransactionServices.class.getName();
        String mn = "isTransactionActive";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "isTransactionActive");
        }
        Instance transactions = CDI.current().select(Transaction.class, new Annotation[0]);
        assert (transactions != null);
        if (!transactions.isUnsatisfied()) {
            Transaction transaction = (Transaction)transactions.get();
            assert (transaction != null);
            boolean temp = false;
            try {
                int status = transaction.getStatus();
                temp = status == 0 || status == 8 || status == 1 || status == 2 || status == 7 || status == 9;
            }
            catch (SystemException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                boolean returnValue2 = temp;
            }
        } else {
            returnValue = false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "isTransactionActive", returnValue);
        }
        return returnValue;
    }

    public void registerSynchronization(Synchronization synchronization) {
        String cn = NarayanaTransactionServices.class.getName();
        String mn = "registerSynchronization";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "registerSynchronization", synchronization);
        }
        CDI cdi = CDI.current();
        Instance transactionInstance = cdi.select(Transaction.class, new Annotation[0]);
        Transaction transaction = null;
        if (transactionInstance.isUnsatisfied()) {
            Instance transactionManagerInstance = cdi.select(jakarta.transaction.TransactionManager.class, new Annotation[0]);
            assert (transactionManagerInstance != null);
            jakarta.transaction.TransactionManager transactionManager = transactionManagerInstance.isUnsatisfied() ? TransactionManager.transactionManager() : (jakarta.transaction.TransactionManager)transactionManagerInstance.get();
            if (transactionManager != null) {
                try {
                    transaction = transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        } else {
            transaction = (Transaction)transactionInstance.get();
        }
        if (transaction != null) {
            try {
                transaction.registerSynchronization(synchronization);
            }
            catch (RollbackException | SystemException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "registerSynchronization");
        }
    }

    public synchronized void cleanup() {
        String cn = NarayanaTransactionServices.class.getName();
        String mn = "cleanup";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "cleanup");
            LOGGER.exiting(cn, "cleanup");
        }
    }
}

