/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.jta.cdi;

import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Singleton;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionScoped;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NarayanaExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(NarayanaExtension.class.getName(), NarayanaExtension.class.getPackage().getName() + ".Messages");
    private static final JTAEnvironmentBean DEFAULT_JTA_ENVIRONMENT_BEAN = (JTAEnvironmentBean)BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class);

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        String cn = NarayanaExtension.class.getName();
        String mn = "afterBeanDiscovery";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "afterBeanDiscovery", new Object[]{event, beanManager});
        }
        if (event != null && beanManager != null) {
            Set beans = beanManager.getBeans(jakarta.transaction.UserTransaction.class, new Annotation[0]);
            if (beans == null || beans.isEmpty()) {
                event.addBean().types(new Type[]{jakarta.transaction.UserTransaction.class}).addQualifiers(new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE}).scope(Dependent.class).createWith(cc -> UserTransaction.userTransaction());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, cn, "afterBeanDiscovery", "addedUserTransactionBean");
                }
            }
            event.addBean().id(Transaction.class.getName()).types(new Type[]{Transaction.class}).addQualifiers(new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE}).scope(TransactionScoped.class).createWith(cc -> {
                try {
                    return ((TransactionManager)CDI.current().select(TransactionManager.class, new Annotation[0]).get()).getTransaction();
                }
                catch (SystemException systemException) {
                    throw new CreationException(systemException.getMessage(), (Throwable)systemException);
                }
            });
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, cn, "afterBeanDiscovery", "addedTransactionBean");
            }
            if ((beans = beanManager.getBeans(JTAEnvironmentBean.class, new Annotation[0])) == null || beans.isEmpty()) {
                event.addBean().addTransitiveTypeClosure(JTAEnvironmentBean.class).addQualifiers(new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE}).scope(Singleton.class).createWith(cc -> DEFAULT_JTA_ENVIRONMENT_BEAN);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, cn, "afterBeanDiscovery", "addedJtaEnvironmentBeanBean");
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "afterBeanDiscovery");
        }
    }

    private static void onStartup(@Observes @Initialized(value=ApplicationScoped.class) @Priority(value=1000) Object event, Event<JTAEnvironmentBean> broadcaster) {
        String cn = NarayanaExtension.class.getName();
        String mn = "onStartup";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "onStartup", new Object[]{event, broadcaster});
        }
        if (broadcaster != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, cn, "onStartup", "firingJtaEnvironmentBean", DEFAULT_JTA_ENVIRONMENT_BEAN);
            }
            broadcaster.fire((Object)DEFAULT_JTA_ENVIRONMENT_BEAN);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "onStartup");
        }
    }
}

