/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.jdbc;

import io.helidon.integrations.jdbc.DelegatingConnection;
import java.sql.Connection;
import java.sql.SQLException;

public class ConditionallyCloseableConnection
extends DelegatingConnection {
    private boolean closeable;

    public ConditionallyCloseableConnection(Connection delegate) {
        this(delegate, true);
    }

    public ConditionallyCloseableConnection(Connection delegate, boolean closeable) {
        super(delegate);
        this.setCloseable(closeable);
    }

    @Override
    public void close() throws SQLException {
        if (this.isCloseable()) {
            super.close();
        }
    }

    public final boolean isCloseable() throws SQLException {
        return this.closeable && !this.isClosed();
    }

    public final void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }
}

