/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.jta.jdbc;

import io.helidon.integrations.jdbc.AbstractDataSource;
import io.helidon.integrations.jdbc.ConditionallyCloseableConnection;
import jakarta.transaction.Synchronization;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;

public final class JtaDataSource
extends AbstractDataSource
implements Synchronization {
    private static final Object UNAUTHENTICATED_CONNECTION_IDENTIFIER = new Object();
    private static final ThreadLocal<? extends Map<JtaDataSource, Map<Object, TransactionSpecificConnection>>> CONNECTIONS_TL = ThreadLocal.withInitial(() -> new HashMap());
    private final Supplier<? extends DataSource> delegateSupplier;
    private final BooleanSupplier transactionIsActiveSupplier;

    public JtaDataSource(DataSource dataSource, BooleanSupplier transactionIsActiveSupplier) {
        this(() -> dataSource, transactionIsActiveSupplier);
    }

    public JtaDataSource(Supplier<? extends DataSource> delegateSupplier, BooleanSupplier transactionIsActiveSupplier) {
        this.delegateSupplier = Objects.requireNonNull(delegateSupplier, "delegateSupplier");
        this.transactionIsActiveSupplier = Objects.requireNonNull(transactionIsActiveSupplier, "transactionIsActiveSupplier");
    }

    public boolean registerWith(Consumer<? super Synchronization> registrar) {
        if (this.transactionIsActiveSupplier.getAsBoolean()) {
            registrar.accept(this);
            return true;
        }
        return false;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        block9: {
            IllegalArgumentException badStatusException;
            CheckedConsumer<Connection> consumer = switch (status) {
                case 3 -> {
                    badStatusException = null;
                    yield Connection::commit;
                }
                case 4 -> {
                    badStatusException = null;
                    yield Connection::rollback;
                }
                default -> {
                    badStatusException = new IllegalArgumentException("Unexpected transaction status after completion: " + status);
                    yield null;
                }
            };
            Map<Object, TransactionSpecificConnection> extantConnectionsMap = CONNECTIONS_TL.get().get((Object)this);
            if (extantConnectionsMap != null) {
                Collection<TransactionSpecificConnection> extantConnections = extantConnectionsMap.values();
                try {
                    if (badStatusException == null) {
                        JtaDataSource.complete(extantConnections, consumer);
                        break block9;
                    }
                    throw badStatusException;
                }
                finally {
                    extantConnections.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void complete(Iterable<? extends TransactionSpecificConnection> connections, CheckedConsumer<? super Connection> consumer) {
        RuntimeException runtimeException = null;
        for (TransactionSpecificConnection transactionSpecificConnection : connections) {
            try {
                consumer.accept((Connection)((Object)transactionSpecificConnection));
            }
            catch (RuntimeException exception) {
                if (runtimeException == null) {
                    runtimeException = exception;
                    continue;
                }
                runtimeException.addSuppressed(exception);
            }
            catch (Exception exception) {
                if (runtimeException == null) {
                    runtimeException = new IllegalStateException(exception.getMessage(), exception);
                    continue;
                }
                runtimeException.addSuppressed(exception);
            }
            finally {
                try {
                    transactionSpecificConnection.restoreAutoCommit();
                }
                catch (RuntimeException exception) {
                    if (runtimeException == null) {
                        runtimeException = exception;
                        continue;
                    }
                    runtimeException.addSuppressed(exception);
                }
                catch (SQLException sqlException) {
                    if (runtimeException == null) {
                        runtimeException = new IllegalStateException(sqlException.getMessage(), sqlException);
                        continue;
                    }
                    runtimeException.addSuppressed(sqlException);
                }
                finally {
                    transactionSpecificConnection.setCloseable(true);
                    try {
                        if (!transactionSpecificConnection.isCloseCalled()) continue;
                        transactionSpecificConnection.close();
                    }
                    catch (SQLException sqlException) {
                        if (runtimeException == null) {
                            runtimeException = new IllegalStateException(sqlException.getMessage(), sqlException);
                            continue;
                        }
                        runtimeException.addSuppressed(sqlException);
                    }
                }
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null, true);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, false);
    }

    private Connection getConnection(String username, String password, boolean useZeroArgumentForm) throws SQLException {
        Object returnValue;
        if (this.transactionIsActiveSupplier.getAsBoolean()) {
            Object id;
            Map extantConnections = CONNECTIONS_TL.get().computeIfAbsent(this, k -> new HashMap());
            TransactionSpecificConnection tsc = (TransactionSpecificConnection)((Object)extantConnections.get(id = useZeroArgumentForm ? UNAUTHENTICATED_CONNECTION_IDENTIFIER : new AuthenticatedConnectionIdentifier(username, password)));
            if (tsc == null) {
                tsc = useZeroArgumentForm ? new TransactionSpecificConnection(this.delegateSupplier.get().getConnection()) : new TransactionSpecificConnection(this.delegateSupplier.get().getConnection(username, password));
                extantConnections.put(id, tsc);
            } else {
                tsc.setCloseCalled(false);
            }
            returnValue = tsc;
        } else {
            returnValue = useZeroArgumentForm ? this.delegateSupplier.get().getConnection() : this.delegateSupplier.get().getConnection(username, password);
        }
        return returnValue;
    }

    private static void sink(Object ignored) {
    }

    @FunctionalInterface
    private static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static final class TransactionSpecificConnection
    extends ConditionallyCloseableConnection {
        private final boolean oldAutoCommit = this.getAutoCommit();
        private boolean closeCalled;

        private TransactionSpecificConnection(Connection delegate) throws SQLException {
            super(delegate, false);
            this.setAutoCommit(false);
        }

        private void restoreAutoCommit() throws SQLException {
            this.setAutoCommit(this.oldAutoCommit);
        }

        public void close() throws SQLException {
            this.setCloseCalled(true);
            super.close();
        }

        private boolean isCloseCalled() throws SQLException {
            return this.closeCalled || this.isClosed();
        }

        private void setCloseCalled(boolean closeCalled) {
            this.closeCalled = closeCalled;
        }
    }

    private static final class AuthenticatedConnectionIdentifier {
        private final String username;
        private final String password;

        private AuthenticatedConnectionIdentifier(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other != null && other.getClass().equals(AuthenticatedConnectionIdentifier.class)) {
                AuthenticatedConnectionIdentifier her = (AuthenticatedConnectionIdentifier)other;
                return Objects.equals(this.username, her.username) && Objects.equals(this.password, her.password);
            }
            return false;
        }
    }
}

