/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.jta.jdbc;

import io.helidon.integrations.jdbc.AbstractDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public final class XADataSourceWrappingDataSource
extends AbstractDataSource {
    private final XADataSource xaDataSource;
    private final Consumer<? super XAResource> resourceEnlister;

    public XADataSourceWrappingDataSource(XADataSource xaDataSource, Consumer<? super XAResource> resourceEnlister) {
        this.xaDataSource = Objects.requireNonNull(xaDataSource, "xaDataSource");
        this.resourceEnlister = Objects.requireNonNull(resourceEnlister, "resourceEnlister");
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null, true);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, false);
    }

    private Connection getConnection(String username, String password, boolean useZeroArgumentForm) throws SQLException {
        XAConnection xaConnection = useZeroArgumentForm ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(username, password);
        try {
            this.resourceEnlister.accept(xaConnection.getXAResource());
        }
        catch (RuntimeException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return xaConnection.getConnection();
    }
}

