/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.openai.OpenAiModerationModel;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.integrations.langchain4j.providers.openai.OpenAi;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiModerationModelConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@Service.Named(value="*")
@Weight(value=90.0)
@Service.Singleton
public class OpenAiModerationModelFactory
implements Service.ServicesFactory<OpenAiModerationModel> {
    private final Supplier<Optional<OpenAiModerationModel>> model;

    OpenAiModerationModelFactory(@Service.Named(value="open-ai.moderation-model") Supplier<Optional<Proxy>> openAiChatModelProxy, @Service.Named(value="open-ai") Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy, Config config) {
        OpenAiModerationModelConfig.Builder configBuilder = (OpenAiModerationModelConfig.Builder)OpenAiModerationModelConfig.builder().config(config.get("langchain4j.open-ai.moderation-model"));
        this.model = () -> OpenAiModerationModelFactory.buildModel(configBuilder, openAiChatModelProxy, openAiProxy, proxy);
    }

    public static OpenAiModerationModel create(OpenAiModerationModelConfig config) {
        if (!config.enabled()) {
            throw new IllegalStateException("Cannot create a model when the configuration is disabled.");
        }
        OpenAiModerationModel.OpenAiModerationModelBuilder builder = OpenAiModerationModel.builder();
        config.baseUrl().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).baseUrl(arg_0));
        config.apiKey().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).apiKey(arg_0));
        config.organizationId().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).organizationId(arg_0));
        config.modelName().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).modelName(arg_0));
        config.timeout().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).timeout(arg_0));
        config.maxRetries().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).maxRetries(arg_0));
        config.logRequests().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).logRequests(arg_0));
        config.logResponses().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).logResponses(arg_0));
        config.proxy().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).proxy(arg_0));
        if (!config.customHeaders().isEmpty()) {
            builder.customHeaders(config.customHeaders());
        }
        return builder.build();
    }

    public List<Service.QualifiedInstance<OpenAiModerationModel>> services() {
        Optional<OpenAiModerationModel> modelOptional = this.model.get();
        if (modelOptional.isEmpty()) {
            return List.of();
        }
        OpenAiModerationModel theModel = modelOptional.get();
        return List.of(Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[0]), Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[]{OpenAi.OPEN_AI_QUALIFIER}));
    }

    private static Optional<OpenAiModerationModel> buildModel(OpenAiModerationModelConfig.Builder configBuilder, Supplier<Optional<Proxy>> openAiModelProxy, Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy) {
        if (!configBuilder.enabled()) {
            return Optional.empty();
        }
        openAiModelProxy.get().or(openAiProxy).or(proxy).ifPresent(configBuilder::proxy);
        return Optional.of(OpenAiModerationModelFactory.create(configBuilder.build()));
    }
}

