/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.client;

import io.helidon.common.context.Contexts;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.jersey.client.ClientAsyncExecutor;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.spi.ThreadPoolExecutorProvider;

@ClientAsyncExecutor
public class ExecutorProvider
extends ThreadPoolExecutorProvider {
    static final String THREAD_NAME_PREFIX = "helidon-client-async-executor";
    private static final Logger LOGGER = Logger.getLogger(ExecutorProvider.class.getName());
    private final LazyValue<Integer> asyncThreadPoolSize = Values.lazy(() -> {
        if (poolSize.filter(i -> i > 0).isEmpty()) {
            LOGGER.config(LocalizationMessages.IGNORED_ASYNC_THREADPOOL_SIZE((Object)poolSize.orElse(0)));
            return Integer.MAX_VALUE;
        }
        LOGGER.config(LocalizationMessages.USING_FIXED_ASYNC_THREADPOOL(poolSize.get()));
        return (Integer)poolSize.get();
    });

    @Inject
    public ExecutorProvider(@Named(value="ClientAsyncThreadPoolSize") Optional<Integer> poolSize) {
        super(THREAD_NAME_PREFIX);
    }

    protected int getMaximumPoolSize() {
        return (Integer)this.asyncThreadPoolSize.get();
    }

    protected int getCorePoolSize() {
        int maximumPoolSize = this.getMaximumPoolSize();
        if (maximumPoolSize != Integer.MAX_VALUE) {
            return maximumPoolSize;
        }
        return 0;
    }

    public ExecutorService getExecutorService() {
        return Contexts.wrap((ExecutorService)super.getExecutorService());
    }
}

