/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.common;

import io.helidon.jersey.common.InvokedResource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;

final class InvokedResourceImpl
implements InvokedResource {
    private static final ConcurrentHashMap<MethodAnnotationKey, Optional<? extends Annotation>> METHOD_ANNOTATION_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassAnnotationKey, Optional<? extends Annotation>> CLASS_ANNOTATION_CACHE = new ConcurrentHashMap();
    private final Optional<Class<?>> definitionClass;
    private final Optional<Class<?>> handlingClass;
    private final Optional<Method> definitionMethod;
    private final Optional<Method> handlingMethod;

    private InvokedResourceImpl(Optional<Method> definitionMethod, Optional<Method> handlingMethod, Optional<Class<?>> handlingClass, Optional<Class<?>> definitionClass) {
        this.definitionMethod = definitionMethod;
        this.handlingMethod = handlingMethod;
        this.handlingClass = handlingClass;
        this.definitionClass = definitionClass;
    }

    static InvokedResource create(ContainerRequestContext context) {
        ExtendedUriInfo uriInfo = (ExtendedUriInfo)context.getUriInfo();
        ResourceMethod matchedResourceMethod = uriInfo.getMatchedResourceMethod();
        Invocable invocable = matchedResourceMethod.getInvocable();
        Class handlingClass = invocable.getHandler().getHandlerClass();
        Method handlingMethod = invocable.getHandlingMethod();
        Class<?> definitionClass = InvokedResourceImpl.getDefinitionClass(handlingClass);
        Method definitionMethod = invocable.getDefinitionMethod();
        return new InvokedResourceImpl(Optional.ofNullable(definitionMethod), Optional.ofNullable(handlingMethod), Optional.ofNullable(handlingClass), Optional.ofNullable(definitionClass));
    }

    @Override
    public Optional<Method> definitionMethod() {
        return this.definitionMethod;
    }

    @Override
    public Optional<Method> handlingMethod() {
        return this.handlingMethod;
    }

    @Override
    public Optional<Class<?>> definitionClass() {
        return this.definitionClass;
    }

    @Override
    public Optional<Class<?>> handlingClass() {
        return this.handlingClass;
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return this.findMethodAnnotation(annotationClass).or(() -> this.findClassAnnotation(annotationClass));
    }

    @Override
    public <T extends Annotation> Optional<T> findMethodAnnotation(Class<T> annotationClass) {
        if (!this.handlingMethod.isPresent() || !this.handlingClass.isPresent()) {
            return Optional.empty();
        }
        Method theMethod = this.handlingMethod().get();
        Class<?> theClass = this.handlingClass.get();
        Class<?> definitionClass = this.definitionClass().orElse(theClass);
        return METHOD_ANNOTATION_CACHE.computeIfAbsent(new MethodAnnotationKey(annotationClass, definitionClass, theClass, theMethod), aKey -> this.findMethodAnnotation(annotationClass, theClass, theMethod));
    }

    @Override
    public <T extends Annotation> Optional<T> findClassAnnotation(Class<T> annotationClass) {
        if (!this.handlingClass.isPresent()) {
            return Optional.empty();
        }
        Class<?> theClass = this.handlingClass.get();
        return CLASS_ANNOTATION_CACHE.computeIfAbsent(new ClassAnnotationKey(annotationClass, theClass), aKey -> this.findClassAnnotation(annotationClass, theClass));
    }

    private <T extends Annotation> Optional<? extends Annotation> findClassAnnotation(Class<T> annotationClass, Class<?> theClass) {
        List<Class<?>> hierarchy = InvokedResourceImpl.hierarchy(theClass);
        for (Class<?> aClass : hierarchy) {
            T annot = aClass.getDeclaredAnnotation(annotationClass);
            if (null == annot) continue;
            return Optional.of(annot);
        }
        return Optional.empty();
    }

    private <T extends Annotation> Optional<? extends Annotation> findMethodAnnotation(Class<T> annotationClass, Class<?> theClass, Method theMethod) {
        List<Class<?>> hierarchy = InvokedResourceImpl.hierarchy(theClass);
        String name = theMethod.getName();
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        for (Class<?> aClass : hierarchy) {
            try {
                Method method = aClass.getDeclaredMethod(name, parameterTypes);
                T annot = method.getDeclaredAnnotation(annotationClass);
                if (null == annot) continue;
                return Optional.of(annot);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return Optional.empty();
    }

    private static List<Class<?>> hierarchy(Class<?> aClass) {
        LinkedList result = new LinkedList();
        HashSet processed = new HashSet();
        result.add(aClass);
        Class<?> current = aClass.getSuperclass();
        while (!Object.class.equals(current)) {
            if (processed.add(current)) {
                result.add(current);
            }
            current = current.getSuperclass();
        }
        LinkedList interfaces = new LinkedList();
        result.forEach(clazz -> InvokedResourceImpl.addInterfaces(clazz, interfaces, processed));
        result.addAll(interfaces);
        return result;
    }

    private static void addInterfaces(Class<?> clazz, List<Class<?>> interfaces, Set<Class<?>> processed) {
        Class<?>[] found;
        for (Class<?> anInterface : found = clazz.getInterfaces()) {
            if (!processed.add(anInterface)) continue;
            interfaces.add(anInterface);
            InvokedResourceImpl.addInterfaces(anInterface, interfaces, processed);
        }
    }

    private static Class<?> getDefinitionClass(Class<?> resourceClass) {
        Class<?> foundInterface = null;
        Class<?> cls = resourceClass;
        block0: do {
            if (cls.isAnnotationPresent(Path.class)) {
                return cls;
            }
            if (foundInterface != null) continue;
            for (Class<?> i : cls.getInterfaces()) {
                if (!i.isAnnotationPresent(Path.class)) continue;
                foundInterface = i;
                continue block0;
            }
        } while ((cls = cls.getSuperclass()) != null);
        if (foundInterface != null) {
            return foundInterface;
        }
        return resourceClass;
    }

    private static final class MethodAnnotationKey {
        private final Class<? extends Annotation> annotationClass;
        private final Class<?> definitionClass;
        private final Class<?> handlingClass;
        private final Method handlingMethod;

        private MethodAnnotationKey(Class<? extends Annotation> annotationClass, Class<?> definitionClass, Class<?> handlingClass, Method handlingMethod) {
            this.annotationClass = annotationClass;
            this.definitionClass = definitionClass;
            this.handlingClass = handlingClass;
            this.handlingMethod = handlingMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodAnnotationKey)) {
                return false;
            }
            MethodAnnotationKey that = (MethodAnnotationKey)o;
            return this.annotationClass.equals(that.annotationClass) && this.definitionClass.equals(that.definitionClass) && this.handlingClass.equals(that.handlingClass) && this.handlingMethod.equals(that.handlingMethod);
        }

        public int hashCode() {
            return Objects.hash(this.annotationClass, this.definitionClass, this.handlingClass, this.handlingMethod);
        }
    }

    private static final class ClassAnnotationKey {
        private final Class<? extends Annotation> annotationClass;
        private final Class<?> handlingClass;

        private ClassAnnotationKey(Class<? extends Annotation> annotationClass, Class<?> handlingClass) {
            this.annotationClass = annotationClass;
            this.handlingClass = handlingClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassAnnotationKey)) {
                return false;
            }
            ClassAnnotationKey that = (ClassAnnotationKey)o;
            return this.annotationClass.equals(that.annotationClass) && this.handlingClass.equals(that.handlingClass);
        }

        public int hashCode() {
            return Objects.hash(this.annotationClass, this.handlingClass);
        }
    }
}

