/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.connector;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

class OutputStreamChannel
extends OutputStream
implements ReadableByteChannel {
    private ReentrantLock lock = new ReentrantLock();
    private static final ByteBuffer VOID = ByteBuffer.allocate(0);
    private static final int CAPACITY = Integer.getInteger("helidon.connector.osc.capacity", 8);
    private static final int WRITE_TIMEOUT = Integer.getInteger("helidon.connector.osc.read.timeout", 10000);
    private static final int READ_TIMEOUT = Integer.getInteger("helidon.connector.osc.write.timeout", 10000);
    private final int bufferSize;
    private final LinkedBlockingDeque<ByteBuffer> queue = new LinkedBlockingDeque(CAPACITY);
    private volatile boolean open = true;
    private ByteBuffer remainingByteBuffer;

    OutputStreamChannel(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int sum = 0;
        do {
            ByteBuffer top;
            try {
                top = this.poll(READ_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.open = false;
                throw new ClosedByInterruptException();
            }
            if (top == null) {
                return sum;
            }
            if (top == VOID) {
                if (sum == 0) {
                    this.open = false;
                    return -1;
                }
                this.queue.addFirst(top);
                return sum;
            }
            int topSize = top.remaining();
            int dstAvailable = dst.remaining();
            int minSize = Math.min(topSize, dstAvailable);
            if (top.hasArray()) {
                dst.put(top.array(), top.arrayOffset() + top.position(), minSize);
                top.position(top.position() + minSize);
            } else {
                while (dst.hasRemaining() && top.hasRemaining()) {
                    dst.put(top.get());
                }
            }
            sum += minSize;
            if (!top.hasRemaining()) continue;
            this.remainingByteBuffer = top;
        } while (dst.hasRemaining());
        return sum;
    }

    private ByteBuffer poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.remainingByteBuffer != null) {
            ByteBuffer remaining = this.remainingByteBuffer;
            this.remainingByteBuffer = null;
            return remaining;
        }
        this.lock.lock();
        ByteBuffer peek = this.queue.poll(timeout, unit);
        this.lock.unlock();
        return peek;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.lock.tryLock()) {
            ByteBuffer buffer;
            if (len < this.bufferSize && this.queue.size() > 0 && (buffer = this.queue.getLast()) != null && buffer.capacity() - buffer.limit() > len) {
                buffer.position(buffer.limit());
                buffer.limit(buffer.capacity());
                buffer.put(b, off, len);
                buffer.flip();
                this.lock.unlock();
                return;
            }
            this.lock.unlock();
        }
        int maxLen = Math.max(len, this.bufferSize);
        byte[] bytes = new byte[maxLen];
        System.arraycopy(b, off, bytes, 0, len);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.limit(len);
        buffer.position(0);
        this.write(buffer);
    }

    private void write(ByteBuffer buffer) throws IOException {
        try {
            boolean queued = this.queue.offer(buffer, WRITE_TIMEOUT, TimeUnit.MILLISECONDS);
            if (!queued) {
                throw new IOException("Buffer overflow.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        boolean offer = false;
        try {
            offer = this.queue.offer(VOID, WRITE_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!offer) {
            this.lock.lock();
            this.queue.removeLast();
            this.queue.add(VOID);
            this.lock.unlock();
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    private void checkClosed() throws IOException {
        if (!this.open) {
            throw new IOException("Stream already closed.");
        }
    }
}

