/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.connector;

import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.jersey.connector.HelidonEntity;
import io.helidon.jersey.connector.HelidonStructures;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientResponse;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.glassfish.jersey.client.ClientAsyncExecutorLiteral;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

class HelidonConnector
implements Connector {
    private static final String HELIDON_VERSION = "Helidon/3.2.12 (java " + (String)PropertiesHelper.getSystemProperty((String)"java.runtime.version").run() + ")";
    static final Logger LOGGER = Logger.getLogger(HelidonConnector.class.getName());
    private final WebClient webClient;
    private final ExecutorServiceKeeper executorServiceKeeper;
    private final HelidonEntity.HelidonEntityType entityType;
    private static final InputStream NO_CONTENT_INPUT_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    static final String INTERNAL_ENTITY_TYPE = "jersey.connector.helidon.entity.type";

    HelidonConnector(Client client, Configuration config) {
        WebClient.Builder webClientBuilder;
        block3: {
            block2: {
                boolean jerseyHasDefaultSsl;
                this.executorServiceKeeper = new ExecutorServiceKeeper(client);
                this.entityType = HelidonConnector.getEntityType(config);
                webClientBuilder = WebClient.builder();
                webClientBuilder.addReader(HelidonStructures.createInputStreamBodyReader());
                HelidonEntity.helidonWriter(this.entityType).ifPresent(arg_0 -> ((WebClient.Builder)webClientBuilder).addWriter(arg_0));
                HelidonStructures.createProxy(config).ifPresent(arg_0 -> ((WebClient.Builder)webClientBuilder).proxy(arg_0));
                Optional<Config> helidonConfig = HelidonStructures.helidonConfig(config);
                helidonConfig.ifPresent(arg_0 -> ((WebClient.Builder)webClientBuilder).config(arg_0));
                webClientBuilder.connectTimeout((long)((Integer)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.connectTimeout", (Object)10000)).intValue(), TimeUnit.MILLISECONDS);
                boolean helidonConfigTlsSet = helidonConfig.map(hc -> hc.get("tls").exists()).orElse(false);
                boolean isJerseyClient = client instanceof JerseyClient;
                boolean bl = jerseyHasDefaultSsl = isJerseyClient && ((JerseyClient)client).isDefaultSslContext();
                if (!helidonConfigTlsSet || !isJerseyClient) break block2;
                if (jerseyHasDefaultSsl) break block3;
            }
            HelidonStructures.createSSL(client.getSslContext()).ifPresent(arg_0 -> ((WebClient.Builder)webClientBuilder).tls(arg_0));
        }
        this.webClient = webClientBuilder.build();
    }

    public ClientResponse apply(ClientRequest request) {
        try {
            return this.applyInternal(request).toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        BiConsumer<ClientResponse, Throwable> action = (r, th) -> {
            if (th == null) {
                callback.response(r);
            } else {
                callback.failure(th);
            }
        };
        return this.applyInternal(request).whenCompleteAsync(action, this.executorServiceKeeper.getExecutorService(request)).toCompletableFuture();
    }

    public String getName() {
        return HELIDON_VERSION;
    }

    public void close() {
    }

    private CompletionStage<ClientResponse> applyInternal(ClientRequest request) {
        Object property;
        WebClientRequestBuilder webClientRequestBuilder = this.webClient.method(request.getMethod());
        webClientRequestBuilder.uri(request.getUri());
        for (String propertyName : request.getConfiguration().getPropertyNames()) {
            property = request.getConfiguration().getProperty(propertyName);
            if (propertyName.startsWith("jersey") || !String.class.isInstance(property)) continue;
            webClientRequestBuilder.property(propertyName, (String)property);
        }
        for (String propertyName : request.getPropertyNames()) {
            property = request.resolveProperty(propertyName, Object.class);
            if (propertyName.startsWith("jersey") || !String.class.isInstance(property)) continue;
            webClientRequestBuilder.property(propertyName, (String)property);
        }
        webClientRequestBuilder.followRedirects(((Boolean)request.resolveProperty("jersey.config.client.followRedirects", (Object)true)).booleanValue());
        webClientRequestBuilder.readTimeout((long)((Integer)request.resolveProperty("jersey.config.client.readTimeout", (Object)10000)).intValue(), TimeUnit.MILLISECONDS);
        Object responseStage = null;
        if (request.hasEntity()) {
            responseStage = HelidonEntity.submit(this.entityType, request, webClientRequestBuilder, this.executorServiceKeeper.getExecutorService(request));
        } else {
            webClientRequestBuilder.headers(HelidonStructures.createHeaders((Map<String, List<String>>)request.getRequestHeaders()));
            responseStage = webClientRequestBuilder.submit();
        }
        return responseStage.thenCompose(a -> this.convertResponse(request, (WebClientResponse)a));
    }

    private CompletionStage<ClientResponse> convertResponse(ClientRequest requestContext, final WebClientResponse webClientResponse) {
        ClientResponse responseContext = new ClientResponse(new Response.StatusType(){

            public int getStatusCode() {
                return webClientResponse.status().code();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)this.getStatusCode());
            }

            public String getReasonPhrase() {
                return webClientResponse.status().reasonPhrase();
            }
        }, requestContext);
        for (Map.Entry entry : webClientResponse.headers().toMap().entrySet()) {
            for (String value : (List)entry.getValue()) {
                responseContext.getHeaders().add((Object)((String)entry.getKey()), (Object)value);
            }
        }
        responseContext.setResolvedRequestUri(webClientResponse.lastEndpointURI());
        Single stream = HelidonStructures.hasEntity(webClientResponse) ? webClientResponse.content().as(InputStream.class) : CompletableFuture.supplyAsync(() -> NO_CONTENT_INPUT_STREAM, this.executorServiceKeeper.getExecutorService(requestContext));
        return stream.thenApply(a -> {
            responseContext.setEntityStream((InputStream)new FilterInputStream((InputStream)a){
                private final AtomicBoolean closed;
                {
                    this.closed = new AtomicBoolean(false);
                }

                @Override
                public void close() throws IOException {
                    if (!this.closed.compareAndSet(false, true)) {
                        super.close();
                    }
                }
            });
            return responseContext;
        });
    }

    private static HelidonEntity.HelidonEntityType getEntityType(Configuration config) {
        String helidonType = (String)ClientProperties.getValue((Map)config.getProperties(), (String)INTERNAL_ENTITY_TYPE, (Object)HelidonEntity.HelidonEntityType.READABLE_BYTE_CHANNEL.name());
        HelidonEntity.HelidonEntityType entityType = HelidonEntity.HelidonEntityType.valueOf(helidonType);
        return entityType;
    }

    private static class ExecutorServiceKeeper {
        private Optional<ExecutorService> executorService;

        private ExecutorServiceKeeper(Client client) {
            ClientConfig config = ((JerseyClient)client).getConfiguration();
            this.executorService = Optional.ofNullable(config.getExecutorService());
        }

        private ExecutorService getExecutorService(ClientRequest request) {
            if (!this.executorService.isPresent()) {
                this.executorService = Optional.ofNullable(((ExecutorServiceProvider)request.getInjectionManager().getInstance(ExecutorServiceProvider.class, new Annotation[]{ClientAsyncExecutorLiteral.INSTANCE})).getExecutorService());
            }
            return this.executorService.get();
        }
    }
}

