/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.connector;

import io.helidon.common.http.Headers;
import io.helidon.config.Config;
import io.helidon.jersey.connector.HelidonConnector;
import io.helidon.media.common.DefaultMediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientTls;
import io.netty.handler.codec.http.HttpHeaderValues;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Configuration;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;

class HelidonStructures {
    private HelidonStructures() {
    }

    static Headers createHeaders(Map<String, List<String>> data) {
        return new ReadOnlyHeaders(data);
    }

    static MessageBodyReader<InputStream> createInputStreamBodyReader() {
        return DefaultMediaSupport.inputStreamReader();
    }

    static Optional<Config> helidonConfig(Configuration configuration) {
        Object helidonConfig = configuration.getProperty("jersey.connector.helidon.config");
        if (helidonConfig != null) {
            if (!Config.class.isInstance(helidonConfig)) {
                HelidonConnector.LOGGER.warning(String.format("Given instance of %s is not Helidon config. Provided HelidonProperties.CONFIG is ignored.", helidonConfig.getClass().getName()));
                return Optional.empty();
            }
            return Optional.of((Config)helidonConfig);
        }
        return Optional.empty();
    }

    static Optional<Proxy> createProxy(Configuration config) {
        return ProxyBuilder.createProxy(config);
    }

    static Optional<Proxy> createProxy(ClientRequest request) {
        return ProxyBuilder.createProxy(request);
    }

    static Optional<WebClientTls> createSSL(SSLContext context) {
        return context == null ? Optional.empty() : Optional.of(WebClientTls.builder().sslContext(context).build());
    }

    static boolean hasEntity(WebClientResponse webClientResponse) {
        io.helidon.common.http.ReadOnlyHeaders headers = webClientResponse.content().readerContext().headers();
        Optional contentLenth = headers.first("Content-Length");
        Optional encoding = headers.first("Transfer-Encoding");
        return contentLenth.isPresent() && !((String)contentLenth.get()).equals("0") || encoding.isPresent() && ((String)encoding.get()).equals(HttpHeaderValues.CHUNKED.toString());
    }

    private static class ReadOnlyHeaders
    extends io.helidon.common.http.ReadOnlyHeaders {
        ReadOnlyHeaders(Map<String, List<String>> data) {
            super(data);
        }
    }

    private static class ProxyBuilder {
        private ProxyBuilder() {
        }

        private static Optional<Proxy> createProxy(Configuration config) {
            Object proxyUri = config.getProperty("jersey.config.client.proxy.uri");
            String userName = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.username", String.class);
            String password = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.password", String.class);
            return ProxyBuilder.createProxy(proxyUri, userName, password);
        }

        private static Optional<Proxy> createProxy(ClientRequest clientRequest) {
            Object proxyUri = clientRequest.resolveProperty("jersey.config.client.proxy.uri", Object.class);
            String userName = (String)clientRequest.resolveProperty("jersey.config.client.proxy.username", String.class);
            String password = (String)clientRequest.resolveProperty("jersey.config.client.proxy.password", String.class);
            return ProxyBuilder.createProxy(proxyUri, userName, password);
        }

        private static Optional<Proxy> createProxy(Object proxyUri, String userName, String password) {
            if (proxyUri != null) {
                URI u = ProxyBuilder.getProxyUri(proxyUri);
                Proxy.Builder builder = Proxy.builder();
                if (u.getScheme().toUpperCase(Locale.ROOT).equals("DIRECT")) {
                    builder.type(Proxy.ProxyType.NONE);
                } else {
                    builder.host(u.getHost()).port(u.getPort());
                    switch (u.getScheme().toUpperCase(Locale.ROOT)) {
                        case "HTTP": {
                            builder.type(Proxy.ProxyType.HTTP);
                            break;
                        }
                        case "SOCKS": {
                            builder.type(Proxy.ProxyType.SOCKS_4);
                            break;
                        }
                        case "SOCKS5": {
                            builder.type(Proxy.ProxyType.SOCKS_5);
                            break;
                        }
                        default: {
                            HelidonConnector.LOGGER.warning(String.format("Proxy schema %s not supported.", u.getScheme()));
                            return Optional.empty();
                        }
                    }
                }
                if (userName != null) {
                    builder.username(userName);
                    if (password != null) {
                        builder.password(password.toCharArray());
                    }
                }
                return Optional.of(builder.build());
            }
            return Optional.empty();
        }

        private static URI getProxyUri(Object proxy) {
            if (proxy instanceof URI) {
                return (URI)proxy;
            }
            if (proxy instanceof String) {
                return URI.create((String)proxy);
            }
            throw new ProcessingException("The proxy URI (" + proxy + ") property MUST be an instance of String or URI");
        }
    }
}

