/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.connector;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.IoMulti;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.OutputStreamMulti;
import io.helidon.common.reactive.Single;
import io.helidon.jersey.connector.OutputStreamChannel;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientResponse;
import jakarta.ws.rs.ProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.glassfish.jersey.client.ClientRequest;

class HelidonEntity {
    private HelidonEntity() {
    }

    static Optional<MessageBodyWriter<?>> helidonWriter(HelidonEntityType type) {
        switch (type) {
            case BYTE_ARRAY_OUTPUT_STREAM: {
                return Optional.of(new OutputStreamBodyWriter());
            }
        }
        return Optional.empty();
    }

    static CompletionStage<WebClientResponse> submit(HelidonEntityType type, ClientRequest requestContext, WebClientRequestBuilder requestBuilder, ExecutorService executorService) {
        Single stage = null;
        if (type != null) {
            int bufferSize = (Integer)requestContext.resolveProperty("jersey.config.client.contentLength.buffer", (Object)8192);
            switch (type) {
                case BYTE_ARRAY_OUTPUT_STREAM: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
                    requestContext.setStreamProvider(contentLength -> baos);
                    ((ProcessingRunnable)() -> ((ClientRequest)requestContext).writeEntity()).run();
                    stage = requestBuilder.submit((Object)baos);
                    break;
                }
                case READABLE_BYTE_CHANNEL: {
                    OutputStreamChannel channel = new OutputStreamChannel(bufferSize);
                    requestContext.setStreamProvider(contentLength -> channel);
                    executorService.execute(() -> ((ClientRequest)requestContext).writeEntity());
                    stage = requestBuilder.submit((Object)channel);
                    break;
                }
                case OUTPUT_STREAM_MULTI: {
                    OutputStreamMulti publisher = IoMulti.outputStreamMulti();
                    requestContext.setStreamProvider(contentLength -> publisher);
                    executorService.execute(() -> {
                        requestContext.writeEntity();
                        publisher.close();
                    });
                    stage = requestBuilder.submit((Flow.Publisher)Multi.create((Flow.Publisher)publisher).map(DataChunk::create));
                    break;
                }
            }
        }
        return stage;
    }

    static enum HelidonEntityType {
        BYTE_ARRAY_OUTPUT_STREAM,
        READABLE_BYTE_CHANNEL,
        OUTPUT_STREAM_MULTI;

    }

    private static class OutputStreamBodyWriter
    implements MessageBodyWriter<ByteArrayOutputStream> {
        private OutputStreamBodyWriter() {
        }

        public Flow.Publisher<DataChunk> write(Single<? extends ByteArrayOutputStream> content, GenericType<? extends ByteArrayOutputStream> type, MessageBodyWriterContext context) {
            context.contentType(MediaType.APPLICATION_OCTET_STREAM);
            return content.flatMap((Function)new ByteArrayOutputStreamToChunks());
        }

        public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext messageBodyWriterContext) {
            return MessageBodyOperator.PredicateResult.supports(ByteArrayOutputStream.class, type);
        }

        private static class ByteArrayOutputStreamToChunks
        implements Function<ByteArrayOutputStream, Flow.Publisher<DataChunk>> {
            private ByteArrayOutputStreamToChunks() {
            }

            @Override
            public Flow.Publisher<DataChunk> apply(ByteArrayOutputStream byteArrayOutputStream) {
                return ContentWriters.writeBytes((byte[])byteArrayOutputStream.toByteArray(), (boolean)false);
            }
        }
    }

    @FunctionalInterface
    private static interface ProcessingRunnable
    extends Runnable {
        public void runOrThrow() throws IOException;

        @Override
        default public void run() {
            try {
                this.runOrThrow();
            }
            catch (IOException e) {
                throw new ProcessingException("Error writing entity:", (Throwable)e);
            }
        }
    }
}

