/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.connector;

import io.helidon.common.LazyValue;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.config.Config;
import io.helidon.http.Header;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.http.media.ReadableEntity;
import io.helidon.jersey.connector.ProxyBuilder;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;

class HelidonConnector
implements Connector {
    static final System.Logger LOGGER = System.getLogger(HelidonConnector.class.getName());
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final Map<String, String> EMPTY_MAP_LIST = Map.of("", "");
    private static final String HELIDON_VERSION = "Helidon/4.2.0 (java " + String.valueOf(PropertiesHelper.getSystemProperty((String)"java.runtime.version")) + ")";
    private static final LazyValue<ExecutorService> EXECUTOR_SERVICE = LazyValue.create(() -> Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("helidon-connector-", 0L).factory()));
    private final WebClient webClient;
    private final Proxy proxy;

    HelidonConnector(Client client, Configuration config) {
        List protocolConfigs;
        boolean jerseyHasDefaultSsl;
        Map properties = config.getProperties();
        WebClientConfig.Builder builder = WebClientConfig.builder();
        Config helidonConfig = HelidonConnector.helidonConfig(config).orElse(Config.empty());
        builder.config((io.helidon.common.config.Config)helidonConfig);
        this.proxy = ProxyBuilder.createProxy(config).orElse(Proxy.create());
        if (properties.containsKey("jersey.config.client.connectTimeout")) {
            builder.connectTimeout(Duration.ofMillis(((Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.connectTimeout", (Object)10000)).intValue()));
        }
        if (properties.containsKey("jersey.config.client.readTimeout")) {
            builder.readTimeout(Duration.ofMillis(((Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.readTimeout", (Object)10000)).intValue()));
        }
        if (properties.containsKey("jersey.config.client.followRedirects")) {
            builder.followRedirects(((Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.followRedirects", (Object)true)).booleanValue());
        }
        if (properties.containsKey("jersey.config.client.request.expect.100.continue.processing")) {
            builder.sendExpectContinue(((Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.request.expect.100.continue.processing", (Object)true)).booleanValue());
        }
        boolean helidonConfigTlsSet = (Boolean)helidonConfig.map(hc -> hc.get("tls").exists()).orElse((Object)false);
        boolean isJerseyClient = client instanceof JerseyClient;
        boolean bl = jerseyHasDefaultSsl = isJerseyClient && ((JerseyClient)client).isDefaultSslContext();
        if (!(helidonConfigTlsSet && isJerseyClient && jerseyHasDefaultSsl)) {
            if (properties.containsKey("jersey.connector.helidon.tls")) {
                builder.tls((Tls)ClientProperties.getValue((Map)properties, (String)"jersey.connector.helidon.tls", Tls.class));
            } else if (client.getSslContext() != null) {
                builder.tls(((TlsConfig.Builder)Tls.builder().sslContext(client.getSslContext())).build());
            }
        }
        if (properties.containsKey("jersey.connector.helidon.protocolConfigs") && (protocolConfigs = (List)properties.get("jersey.connector.helidon.protocolConfigs")) != null) {
            builder.addProtocolConfigs(protocolConfigs);
        }
        if (properties.containsKey("jersey.connector.helidon.defaultHeaders")) {
            builder.defaultHeadersMap((Map)ClientProperties.getValue((Map)properties, (String)"jersey.connector.helidon.defaultHeaders", EMPTY_MAP_LIST));
        }
        if (properties.containsKey("jersey.connector.helidon.shareConnectionCache")) {
            builder.shareConnectionCache(((Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.connector.helidon.shareConnectionCache", (Object)false)).booleanValue());
        }
        this.webClient = builder.build();
    }

    private HttpClientRequest mapRequest(ClientRequest request) {
        String stringValue;
        Object value2;
        String protocolId;
        Integer readTimeout;
        Proxy requestProxy = ProxyBuilder.createProxy(request).orElse(this.proxy);
        URI uri = request.getUri();
        HttpClientRequest httpRequest = (HttpClientRequest)((HttpClientRequest)((HttpClientRequest)this.webClient.method(Method.create((String)request.getMethod()))).proxy(requestProxy)).uri(uri);
        request.getRequestHeaders().forEach((key, value) -> {
            String[] values = value.toArray(new String[0]);
            httpRequest.header(HeaderNames.create((String)key), values);
        });
        Boolean followRedirects = (Boolean)request.resolveProperty("jersey.config.client.followRedirects", Boolean.class);
        if (followRedirects != null) {
            httpRequest.followRedirects(followRedirects.booleanValue());
        }
        if ((readTimeout = (Integer)request.resolveProperty("jersey.config.client.readTimeout", Integer.class)) != null) {
            httpRequest.readTimeout(Duration.ofMillis(readTimeout.intValue()));
        }
        if ((protocolId = (String)request.resolveProperty("jersey.connector.helidon.protocolId", String.class)) != null) {
            httpRequest.protocolId(protocolId);
        }
        for (String name : request.getConfiguration().getPropertyNames()) {
            value2 = request.getConfiguration().getProperty(name);
            if (name.startsWith("jersey") || !(value2 instanceof String)) continue;
            stringValue = (String)value2;
            httpRequest.property(name, stringValue);
        }
        for (String propertyName : request.getPropertyNames()) {
            value2 = request.resolveProperty(propertyName, Object.class);
            if (propertyName.startsWith("jersey") || !(value2 instanceof String)) continue;
            stringValue = (String)value2;
            httpRequest.property(propertyName, stringValue);
        }
        return httpRequest;
    }

    private ClientResponse mapResponse(final HttpClientResponse httpResponse, ClientRequest request) {
        Response.StatusType statusType = new Response.StatusType(){

            public int getStatusCode() {
                return httpResponse.status().code();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)this.getStatusCode());
            }

            public String getReasonPhrase() {
                return httpResponse.status().reasonPhrase();
            }
        };
        ClientResponse response = new ClientResponse(this, statusType, request){

            public void close() {
                super.close();
                httpResponse.close();
            }
        };
        for (Header header : httpResponse.headers()) {
            for (String v : header.allValues()) {
                response.getHeaders().add((Object)header.name(), (Object)v);
            }
        }
        response.setResolvedRequestUri(httpResponse.lastEndpointUri().toUri());
        ReadableEntity entity = httpResponse.entity();
        if (entity.hasEntity()) {
            response.setEntityStream(entity.inputStream());
        }
        return response;
    }

    public ClientResponse apply(ClientRequest request) {
        HttpClientRequest httpRequest = this.mapRequest(request);
        HttpClientResponse httpResponse = request.hasEntity() ? httpRequest.outputStream(os -> {
            request.setStreamProvider(length -> os);
            request.writeEntity();
        }) : httpRequest.request();
        return this.mapResponse(httpResponse, request);
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        return ((ExecutorService)EXECUTOR_SERVICE.get()).submit(() -> {
            try {
                ClientResponse response = this.apply(request);
                callback.response(response);
            }
            catch (Throwable t) {
                callback.failure(t);
            }
        });
    }

    public String getName() {
        return HELIDON_VERSION;
    }

    public void close() {
    }

    WebClient client() {
        return this.webClient;
    }

    Proxy proxy() {
        return this.proxy;
    }

    static Optional<Config> helidonConfig(Configuration configuration) {
        Object helidonConfig = configuration.getProperty("jersey.connector.helidon.config");
        if (helidonConfig != null) {
            if (!(helidonConfig instanceof Config)) {
                LOGGER.log(System.Logger.Level.WARNING, String.format("Ignoring Helidon Connector config at '%s'", "jersey.connector.helidon.config"));
            } else {
                return Optional.of((Config)helidonConfig);
            }
        }
        return Optional.empty();
    }
}

