/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jersey.connector;

import io.helidon.common.LazyValue;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.config.Config;
import io.helidon.http.Header;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.http.media.ReadableEntity;
import io.helidon.jersey.connector.ProxyBuilder;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.Services;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;

class HelidonConnector
implements Connector {
    static final System.Logger LOGGER = System.getLogger(HelidonConnector.class.getName());
    private static final String CONNECTOR_CONFIG_ROOT = "jersey.connector.webclient";
    private static final String HELIDON_VERSION = "Helidon/4.2.2 (java " + String.valueOf(PropertiesHelper.getSystemProperty((String)"java.runtime.version")) + ")";
    private static final LazyValue<ExecutorService> EXECUTOR_SERVICE = LazyValue.create(() -> Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("helidon-connector-", 0L).factory()));
    private final WebClient webClient;
    private final Proxy proxy;

    HelidonConnector(Client client, Configuration configuration) {
        Boolean shareConnectionCache;
        Map defaultHeaders;
        List protocolConfigs;
        Tls tls;
        Boolean expect100Continue;
        Boolean followRedirects;
        Integer readTimeout;
        Integer connectTimeout;
        Map properties = configuration.getProperties();
        WebClientConfig.Builder builder = WebClientConfig.builder();
        Object helidonConfig = configuration.getProperty("jersey.connector.helidon.config");
        if (helidonConfig != null) {
            if (helidonConfig instanceof Config) {
                builder.config((io.helidon.common.config.Config)((Config)helidonConfig));
            } else {
                LOGGER.log(System.Logger.Level.WARNING, String.format("Ignoring Helidon Connector config at '%s'", "jersey.connector.helidon.config"));
                builder.config((io.helidon.common.config.Config)this.configFromRegistry());
            }
        } else {
            builder.config((io.helidon.common.config.Config)this.configFromRegistry());
        }
        this.proxy = ProxyBuilder.createProxy(configuration).orElse(Proxy.create());
        if (properties.containsKey("jersey.config.client.connectTimeout") && (connectTimeout = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.connectTimeout", Integer.class)) != null) {
            builder.connectTimeout(Duration.ofMillis(connectTimeout.intValue()));
        }
        if (properties.containsKey("jersey.config.client.readTimeout") && (readTimeout = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.readTimeout", Integer.class)) != null) {
            builder.readTimeout(Duration.ofMillis(readTimeout.intValue()));
        }
        if (properties.containsKey("jersey.config.client.followRedirects") && (followRedirects = (Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.followRedirects", Boolean.class)) != null) {
            builder.followRedirects(followRedirects.booleanValue());
        }
        if (properties.containsKey("jersey.config.client.request.expect.100.continue.processing") && (expect100Continue = (Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.request.expect.100.continue.processing", Boolean.class)) != null) {
            builder.sendExpectContinue(expect100Continue.booleanValue());
        }
        boolean isTlsSet = false;
        if (properties.containsKey("jersey.connector.helidon.tls") && (tls = (Tls)ClientProperties.getValue((Map)properties, (String)"jersey.connector.helidon.tls", Tls.class)) != null) {
            builder.tls(tls);
            isTlsSet = true;
        }
        if (!isTlsSet && client.getSslContext() != null) {
            boolean jerseyHasDefaultSsl;
            boolean isJerseyClient = client instanceof JerseyClient;
            boolean bl = jerseyHasDefaultSsl = isJerseyClient && ((JerseyClient)client).isDefaultSslContext();
            if (!isJerseyClient || !jerseyHasDefaultSsl) {
                builder.tls(((TlsConfig.Builder)Tls.builder().sslContext(client.getSslContext())).build());
            }
        }
        if (properties.containsKey("jersey.connector.helidon.protocolConfigs") && (protocolConfigs = (List)properties.get("jersey.connector.helidon.protocolConfigs")) != null) {
            builder.addProtocolConfigs(protocolConfigs);
        }
        if (properties.containsKey("jersey.connector.helidon.defaultHeaders") && (defaultHeaders = (Map)ClientProperties.getValue((Map)properties, (String)"jersey.connector.helidon.defaultHeaders", Map.class)) != null) {
            builder.defaultHeadersMap(defaultHeaders);
        }
        if (properties.containsKey("jersey.connector.helidon.shareConnectionCache") && (shareConnectionCache = (Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.connector.helidon.shareConnectionCache", Boolean.class)) != null) {
            builder.shareConnectionCache(shareConnectionCache.booleanValue());
        }
        this.webClient = builder.build();
    }

    private HttpClientRequest mapRequest(ClientRequest request) {
        String stringValue;
        Object value2;
        String protocolId;
        Integer readTimeout;
        Proxy requestProxy = ProxyBuilder.createProxy(request).orElse(this.proxy);
        URI uri = request.getUri();
        HttpClientRequest httpRequest = (HttpClientRequest)((HttpClientRequest)((HttpClientRequest)this.webClient.method(Method.create((String)request.getMethod()))).proxy(requestProxy)).uri(uri);
        request.getRequestHeaders().forEach((key, value) -> {
            String[] values = value.toArray(new String[0]);
            httpRequest.header(HeaderNames.create((String)key), values);
        });
        Boolean followRedirects = (Boolean)request.resolveProperty("jersey.config.client.followRedirects", Boolean.class);
        if (followRedirects != null) {
            httpRequest.followRedirects(followRedirects.booleanValue());
        }
        if ((readTimeout = (Integer)request.resolveProperty("jersey.config.client.readTimeout", Integer.class)) != null) {
            httpRequest.readTimeout(Duration.ofMillis(readTimeout.intValue()));
        }
        if ((protocolId = (String)request.resolveProperty("jersey.connector.helidon.protocolId", String.class)) != null) {
            httpRequest.protocolId(protocolId);
        }
        for (String name : request.getConfiguration().getPropertyNames()) {
            value2 = request.getConfiguration().getProperty(name);
            if (name.startsWith("jersey") || !(value2 instanceof String)) continue;
            stringValue = (String)value2;
            httpRequest.property(name, stringValue);
        }
        for (String propertyName : request.getPropertyNames()) {
            value2 = request.resolveProperty(propertyName, Object.class);
            if (propertyName.startsWith("jersey") || !(value2 instanceof String)) continue;
            stringValue = (String)value2;
            httpRequest.property(propertyName, stringValue);
        }
        return httpRequest;
    }

    private ClientResponse mapResponse(final HttpClientResponse httpResponse, ClientRequest request) {
        Response.StatusType statusType = new Response.StatusType(){

            public int getStatusCode() {
                return httpResponse.status().code();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)this.getStatusCode());
            }

            public String getReasonPhrase() {
                return httpResponse.status().reasonPhrase();
            }
        };
        ClientResponse response = new ClientResponse(this, statusType, request){

            public void close() {
                super.close();
                httpResponse.close();
            }
        };
        for (Header header : httpResponse.headers()) {
            for (String v : header.allValues()) {
                response.getHeaders().add((Object)header.name(), (Object)v);
            }
        }
        response.setResolvedRequestUri(httpResponse.lastEndpointUri().toUri());
        ReadableEntity entity = httpResponse.entity();
        if (entity.hasEntity()) {
            response.setEntityStream(entity.inputStream());
        }
        return response;
    }

    public ClientResponse apply(ClientRequest request) {
        HttpClientRequest httpRequest = this.mapRequest(request);
        HttpClientResponse httpResponse = request.hasEntity() ? httpRequest.outputStream(os -> {
            request.setStreamProvider(length -> os);
            request.writeEntity();
        }) : httpRequest.request();
        return this.mapResponse(httpResponse, request);
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        return ((ExecutorService)EXECUTOR_SERVICE.get()).submit(() -> {
            try {
                ClientResponse response = this.apply(request);
                callback.response(response);
            }
            catch (Throwable t) {
                callback.failure(t);
            }
        });
    }

    public String getName() {
        return HELIDON_VERSION;
    }

    public void close() {
    }

    WebClient client() {
        return this.webClient;
    }

    Proxy proxy() {
        return this.proxy;
    }

    Config configFromRegistry() {
        try {
            io.helidon.common.config.Config cfg = (io.helidon.common.config.Config)Services.get(io.helidon.common.config.Config.class);
            if (cfg instanceof Config) {
                Config config = (Config)cfg;
                return config.get(CONNECTOR_CONFIG_ROOT);
            }
        }
        catch (ServiceRegistryException serviceRegistryException) {
            // empty catch block
        }
        LOGGER.log(System.Logger.Level.TRACE, "Unable to find Config in service registry");
        return Config.empty();
    }
}

