/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.jul;

import io.helidon.logging.common.HelidonMdc;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelidonFormatter
extends SimpleFormatter {
    private static final String THREAD = "thread";
    private static final String THREAD_TOKEN = "!thread!";
    private static final Pattern THREAD_PATTERN = Pattern.compile("!thread!");
    private static final Pattern X_VALUE = Pattern.compile("(\\s?%X\\{)(\\S*?)(})");
    private static final Map<String, Pattern> PATTERN_CACHE = new HashMap<String, Pattern>();
    private static final String JUL_FORMAT_PROP_KEY = "java.util.logging.SimpleFormatter.format";
    private final String format = LogManager.getLogManager().getProperty("java.util.logging.SimpleFormatter.format");
    private final Set<String> parsedProps = new HashSet<String>();
    private final boolean thread = this.format.contains("!thread!") || this.format.contains("%X{thread}");

    public HelidonFormatter() {
        Matcher matcher = X_VALUE.matcher(this.format);
        while (matcher.find()) {
            this.parsedProps.add(matcher.group(2));
        }
    }

    @Override
    public String format(LogRecord record) {
        String message = this.thread ? this.thread() : this.format;
        for (String parsedKey : this.parsedProps) {
            String value = HelidonMdc.get((String)parsedKey).orElse("");
            message = PATTERN_CACHE.computeIfAbsent(parsedKey, key -> Pattern.compile("%X\\{" + key + "}")).matcher(message).replaceAll(value);
        }
        return this.formatRow(record, message);
    }

    private String thread() {
        String currentThread = Thread.currentThread().toString();
        String message = PATTERN_CACHE.computeIfAbsent(THREAD, key -> Pattern.compile("%X\\{thread}")).matcher(this.format).replaceAll(currentThread);
        message = THREAD_PATTERN.matcher(message).replaceAll(currentThread);
        return message;
    }

    private String formatRow(LogRecord record, String format) {
        Object source;
        ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = (String)source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format(format, zdt, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
    }
}

