/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.ReadableByteChannelPublisher;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.function.Function;

public final class ContentWriters {
    private ContentWriters() {
    }

    public static Single<DataChunk> writeBytes(byte[] bytes, boolean copy) {
        byte[] data;
        if (copy) {
            data = new byte[bytes.length];
            System.arraycopy(bytes, 0, data, 0, bytes.length);
        } else {
            data = bytes;
        }
        return Single.just((Object)DataChunk.create((boolean)false, (ByteBuffer)ByteBuffer.wrap(data)));
    }

    public static Single<DataChunk> writeCharSequence(CharSequence cs, Charset charset) {
        return Single.just((Object)DataChunk.create((boolean)false, (ByteBuffer)charset.encode(cs.toString())));
    }

    public static Single<DataChunk> writeCharBuffer(CharBuffer buffer, Charset charset) {
        return Single.just((Object)DataChunk.create((boolean)false, (ByteBuffer)buffer.encode(charset)));
    }

    public static Function<byte[], Flow.Publisher<DataChunk>> byteArrayWriter(boolean copy) {
        return bytes -> ContentWriters.writeBytes(bytes, copy);
    }

    public static Function<CharSequence, Flow.Publisher<DataChunk>> charSequenceWriter(Charset charset) {
        return cs -> ContentWriters.writeCharSequence(cs, charset);
    }

    public static Function<CharBuffer, Flow.Publisher<DataChunk>> charBufferWriter(Charset charset) {
        return buffer -> ContentWriters.writeCharBuffer(buffer, charset);
    }

    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter(RetrySchema retrySchema) {
        RetrySchema schema = retrySchema == null ? RetrySchema.linear((long)0L, (long)10L, (long)250L) : retrySchema;
        return channel -> new ReadableByteChannelPublisher((ReadableByteChannel)channel, schema);
    }

    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter() {
        return ContentWriters.byteChannelWriter(null);
    }
}

