/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.IoMulti;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.CharBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;

public final class ContentWriters {
    private ContentWriters() {
    }

    public static Single<DataChunk> writeBytes(byte[] bytes, boolean copy) {
        byte[] data;
        if (copy) {
            data = new byte[bytes.length];
            System.arraycopy(bytes, 0, data, 0, bytes.length);
        } else {
            data = bytes;
        }
        return Single.just((Object)DataChunk.create((boolean)false, (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(data)}));
    }

    public static Single<DataChunk> writeCharSequence(CharSequence cs, Charset charset) {
        return Single.just((Object)DataChunk.create((boolean)false, (ByteBuffer[])new ByteBuffer[]{charset.encode(cs.toString())}));
    }

    public static Single<DataChunk> writeCharBuffer(CharBuffer buffer, Charset charset) {
        return Single.just((Object)DataChunk.create((boolean)false, (ByteBuffer[])new ByteBuffer[]{buffer.encode(charset)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Single<DataChunk> writeStackTrace(Throwable throwable, Charset charset) {
        StringWriter stringWriter = new StringWriter();
        String stackTraceString = null;
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
            stackTraceString = stringWriter.toString();
        }
        Single<DataChunk> returnValue = stackTraceString.isEmpty() ? Single.empty() : ContentWriters.writeCharSequence(stackTraceString, charset);
        return returnValue;
    }

    @Deprecated(since="2.0.0")
    public static Function<byte[], Flow.Publisher<DataChunk>> byteArrayWriter(boolean copy) {
        return bytes -> ContentWriters.writeBytes(bytes, copy);
    }

    @Deprecated(since="2.0.0")
    public static Function<CharSequence, Flow.Publisher<DataChunk>> charSequenceWriter(Charset charset) {
        return cs -> ContentWriters.writeCharSequence(cs, charset);
    }

    @Deprecated(since="2.0.0")
    public static Function<CharBuffer, Flow.Publisher<DataChunk>> charBufferWriter(Charset charset) {
        return buffer -> ContentWriters.writeCharBuffer(buffer, charset);
    }

    @Deprecated(since="2.0.0")
    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter(RetrySchema retrySchema) {
        Objects.requireNonNull(retrySchema);
        return channel -> IoMulti.multiFromByteChannelBuilder((ReadableByteChannel)channel).retrySchema(retrySchema).build().map(DataChunk::create);
    }

    @Deprecated(since="2.0.0")
    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter() {
        return channel -> IoMulti.multiFromByteChannel((ReadableByteChannel)channel).map(DataChunk::create);
    }
}

