/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.FormParams;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;

class FormParamsBodyWriter
implements MessageBodyWriter<FormParams> {
    private static final FormParamsBodyWriter DEFAULT = new FormParamsBodyWriter();
    private static final MediaType DEFAULT_FORM_MEDIA_TYPE = MediaType.APPLICATION_FORM_URLENCODED;

    private FormParamsBodyWriter() {
    }

    static MessageBodyWriter<FormParams> create() {
        return DEFAULT;
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return context.contentType().or(() -> Optional.of(DEFAULT_FORM_MEDIA_TYPE)).filter(mediaType -> mediaType == MediaType.APPLICATION_FORM_URLENCODED || mediaType == MediaType.TEXT_PLAIN).map(it -> MessageBodyOperator.PredicateResult.supports(FormParams.class, type)).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    @Override
    public Flow.Publisher<DataChunk> write(Single<? extends FormParams> single, GenericType<? extends FormParams> type, MessageBodyWriterContext context) {
        MediaType mediaType = context.contentType().orElseGet(() -> {
            context.contentType(DEFAULT_FORM_MEDIA_TYPE);
            return DEFAULT_FORM_MEDIA_TYPE;
        });
        Charset charset = mediaType.charset().map(Charset::forName).orElse(StandardCharsets.UTF_8);
        return single.flatMap((Function)((Object)new FormParamsToChunks(mediaType, charset)));
    }

    static final class FormParamsToChunks
    implements Mapper<FormParams, Flow.Publisher<DataChunk>> {
        private final MediaType mediaType;
        private final Charset charset;

        FormParamsToChunks(MediaType mediaType, Charset charset) {
            this.mediaType = mediaType;
            this.charset = charset;
        }

        public Flow.Publisher<DataChunk> map(FormParams formParams) {
            return ContentWriters.writeCharSequence(this.transform(formParams), this.charset);
        }

        private String transform(FormParams formParams) {
            char separator = this.separator();
            Function<String, String> encoder = this.encoder();
            StringBuilder result = new StringBuilder();
            for (Map.Entry entry : formParams.toMap().entrySet()) {
                List values = (List)entry.getValue();
                if (values.size() == 0) {
                    if (result.length() > 0) {
                        result.append(separator);
                    }
                    result.append(encoder.apply((String)entry.getKey()));
                    continue;
                }
                for (String value : values) {
                    if (result.length() > 0) {
                        result.append(separator);
                    }
                    result.append(encoder.apply((String)entry.getKey()));
                    result.append("=");
                    result.append(encoder.apply(value));
                }
            }
            return result.toString();
        }

        private char separator() {
            if (this.mediaType == MediaType.TEXT_PLAIN) {
                return '\n';
            }
            return '&';
        }

        private Function<String, String> encoder() {
            if (this.mediaType == MediaType.TEXT_PLAIN) {
                return s -> s;
            }
            return s -> URLEncoder.encode(s, this.charset);
        }
    }
}

