/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyFilter;
import io.helidon.media.common.MessageBodyFilters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyOperators;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MessageBodyContext
implements MessageBodyFilters {
    private static final Logger LOGGER = Logger.getLogger(MessageBodyContext.class.getName());
    private static final Event BEFORE_ONSUBSCRIBE = new EventImpl(EventType.BEFORE_ONSUBSCRIBE, Optional.empty());
    private static final Event BEFORE_ONNEXT = new EventImpl(EventType.BEFORE_ONNEXT, Optional.empty());
    private static final Event BEFORE_ONCOMPLETE = new EventImpl(EventType.BEFORE_ONCOMPLETE, Optional.empty());
    private static final Event AFTER_ONSUBSCRIBE = new EventImpl(EventType.AFTER_ONSUBSCRIBE, Optional.empty());
    private static final Event AFTER_ONNEXT = new EventImpl(EventType.AFTER_ONNEXT, Optional.empty());
    private static final Event AFTER_ONCOMPLETE = new EventImpl(EventType.AFTER_ONCOMPLETE, Optional.empty());
    private final MessageBodyOperators<FilterOperator> filters;
    private final EventListener eventListener;

    protected MessageBodyContext(MessageBodyContext parent, EventListener eventListener) {
        this.filters = parent != null ? new MessageBodyOperators<FilterOperator>(parent.filters) : new MessageBodyOperators();
        this.eventListener = eventListener;
    }

    protected MessageBodyContext(MessageBodyContext parent) {
        this(parent, parent.eventListener);
    }

    public abstract Charset charset() throws IllegalStateException;

    @Override
    public MessageBodyContext registerFilter(MessageBodyFilter filter) {
        Objects.requireNonNull(filter, "filter is null!");
        this.filters.registerLast(new FilterOperator(filter));
        return this;
    }

    public Flow.Publisher<DataChunk> applyFilters(Flow.Publisher<DataChunk> publisher) {
        return this.doApplyFilters(publisher, this.eventListener);
    }

    protected Flow.Publisher<DataChunk> applyFilters(Flow.Publisher<DataChunk> publisher, GenericType<?> type) {
        Objects.requireNonNull(type, "type cannot be null!");
        if (this.eventListener != null) {
            return this.doApplyFilters(publisher, new TypedEventListener(this.eventListener, type));
        }
        return this.doApplyFilters(publisher, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Flow.Publisher<DataChunk> doApplyFilters(Flow.Publisher<DataChunk> publisher, EventListener listener) {
        if (publisher == null) {
            publisher = Single.empty();
        }
        try {
            Object last = publisher;
            for (MessageBodyFilter messageBodyFilter : this.filters) {
                Flow.Publisher p = (Flow.Publisher)messageBodyFilter.apply(last);
                if (p == null) continue;
                last = p;
            }
            EventingPublisher eventingPublisher = new EventingPublisher((Flow.Publisher<DataChunk>)last, listener);
            return eventingPublisher;
        }
        finally {
            this.filters.close();
        }
    }

    private static final class ErrorEventImpl
    extends EventImpl
    implements ErrorEvent {
        private final Throwable error;

        ErrorEventImpl(ErrorEventImpl event, Optional<GenericType<?>> type) {
            super(event.eventType(), type);
            this.error = event.error;
        }

        ErrorEventImpl(Throwable error, EventType eventType) {
            super(eventType, Optional.empty());
            Objects.requireNonNull(error, "error cannot be null!");
            this.error = error;
        }

        @Override
        public Throwable error() {
            return this.error;
        }
    }

    private static class EventImpl
    implements Event {
        private final EventType eventType;
        private final Optional<GenericType<?>> entityType;

        EventImpl(EventImpl event, Optional<GenericType<?>> entityType) {
            this(event.eventType, entityType);
        }

        EventImpl(EventType eventType, Optional<GenericType<?>> entityType) {
            this.eventType = eventType;
            this.entityType = entityType;
        }

        @Override
        public Optional<GenericType<?>> entityType() {
            return this.entityType;
        }

        @Override
        public EventType eventType() {
            return this.eventType;
        }
    }

    private static final class TypedEventListener
    implements EventListener {
        private final EventListener delegate;
        private final Optional<GenericType<?>> entityType;

        TypedEventListener(EventListener delegate, GenericType<?> entityType) {
            this.delegate = delegate;
            this.entityType = Optional.of(entityType);
        }

        @Override
        public void onEvent(Event event) {
            EventImpl copy;
            if (event instanceof ErrorEventImpl) {
                copy = new ErrorEventImpl((ErrorEventImpl)event, this.entityType);
            } else if (event instanceof EventImpl) {
                copy = new EventImpl((EventImpl)event, this.entityType);
            } else {
                throw new IllegalStateException("Unknown event type " + event);
            }
            this.delegate.onEvent(copy);
        }
    }

    private static final class FilterOperator
    implements MessageBodyOperator<MessageBodyContext>,
    MessageBodyFilter {
        private final MessageBodyFilter filter;

        FilterOperator(MessageBodyFilter filter) {
            this.filter = filter;
        }

        @Override
        public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyContext context) {
            return MessageBodyOperator.PredicateResult.SUPPORTED;
        }

        @Override
        public Flow.Publisher<DataChunk> apply(Flow.Publisher<DataChunk> publisher) {
            return (Flow.Publisher)this.filter.apply(publisher);
        }
    }

    private static final class EventingSubscriber
    implements Flow.Subscriber<DataChunk> {
        private final Flow.Subscriber<? super DataChunk> delegate;
        private final EventListener listener;

        EventingSubscriber(Flow.Subscriber<? super DataChunk> delegate, EventListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        private void fireEvent(Event event) {
            if (this.listener != null) {
                try {
                    this.listener.onEvent(event);
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.WARNING, "An exception occurred in EventListener.onEvent", ex);
                }
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.fireEvent(BEFORE_ONSUBSCRIBE);
            try {
                this.delegate.onSubscribe(subscription);
            }
            finally {
                this.fireEvent(AFTER_ONSUBSCRIBE);
            }
        }

        @Override
        public void onNext(DataChunk item) {
            this.fireEvent(BEFORE_ONNEXT);
            try {
                this.delegate.onNext((DataChunk)item);
            }
            finally {
                this.fireEvent(AFTER_ONNEXT);
            }
        }

        @Override
        public void onError(Throwable error) {
            this.fireEvent(new ErrorEventImpl(error, EventType.BEFORE_ONERROR));
            try {
                this.delegate.onError(error);
            }
            finally {
                this.fireEvent(new ErrorEventImpl(error, EventType.AFTER_ONERROR));
            }
        }

        @Override
        public void onComplete() {
            this.fireEvent(BEFORE_ONCOMPLETE);
            try {
                this.delegate.onComplete();
            }
            finally {
                this.fireEvent(AFTER_ONCOMPLETE);
            }
        }
    }

    private static final class EventingPublisher
    implements Flow.Publisher<DataChunk> {
        private final Flow.Publisher<DataChunk> publisher;
        private final EventListener listener;

        EventingPublisher(Flow.Publisher<DataChunk> publisher, EventListener listener) {
            this.publisher = publisher;
            this.listener = listener;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
            this.publisher.subscribe(new EventingSubscriber(subscriber, this.listener));
        }
    }

    public static interface ErrorEvent
    extends Event {
        public Throwable error();
    }

    public static interface Event {
        public EventType eventType();

        public Optional<GenericType<?>> entityType();

        default public ErrorEvent asErrorEvent() {
            if (!(this instanceof ErrorEvent)) {
                throw new IllegalStateException("Not an error event");
            }
            return (ErrorEvent)this;
        }
    }

    public static enum EventType {
        BEFORE_ONSUBSCRIBE,
        AFTER_ONSUBSCRIBE,
        BEFORE_ONNEXT,
        AFTER_ONNEXT,
        BEFORE_ONERROR,
        AFTER_ONERROR,
        BEFORE_ONCOMPLETE,
        AFTER_ONCOMPLETE;

    }

    public static interface EventListener {
        public void onEvent(Event var1);
    }
}

