/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyFilters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyOperators;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaders;
import io.helidon.media.common.MessageBodyStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Predicate;

public final class MessageBodyReaderContext
extends MessageBodyContext
implements MessageBodyReaders,
MessageBodyFilters {
    static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final ReadOnlyParameters headers;
    private final Optional<MediaType> contentType;
    private final MessageBodyOperators<MessageBodyReader<?>> readers;
    private final MessageBodyOperators<MessageBodyStreamReader<?>> sreaders;

    private MessageBodyReaderContext(MessageBodyReaderContext parent, MessageBodyContext.EventListener eventListener, ReadOnlyParameters headers, Optional<MediaType> contentType) {
        super(parent, eventListener);
        Objects.requireNonNull(headers, "headers cannot be null!");
        Objects.requireNonNull(contentType, "contentType cannot be null!");
        this.headers = headers;
        this.contentType = contentType;
        if (parent != null) {
            this.readers = new MessageBodyOperators(parent.readers);
            this.sreaders = new MessageBodyOperators(parent.sreaders);
        } else {
            this.readers = new MessageBodyOperators();
            this.sreaders = new MessageBodyOperators();
        }
    }

    private MessageBodyReaderContext() {
        super(null, null);
        this.headers = ReadOnlyParameters.empty();
        this.contentType = Optional.empty();
        this.readers = new MessageBodyOperators();
        this.sreaders = new MessageBodyOperators();
    }

    private MessageBodyReaderContext(MessageBodyReaderContext parent) {
        super(parent);
        this.headers = parent.headers;
        this.contentType = parent.contentType;
        this.readers = new MessageBodyOperators(parent.readers);
        this.sreaders = new MessageBodyOperators(parent.sreaders);
    }

    public static MessageBodyReaderContext create() {
        return new MessageBodyReaderContext();
    }

    @Override
    public MessageBodyReaderContext registerReader(MessageBodyReader<?> reader) {
        this.readers.registerFirst(reader);
        return this;
    }

    @Override
    public MessageBodyReaderContext registerReader(MessageBodyStreamReader<?> reader) {
        this.sreaders.registerFirst(reader);
        return this;
    }

    @Deprecated
    public <T> void registerReader(Class<T> type, Reader<T> reader) {
        this.readers.registerFirst(new ReaderAdapter<T>(type, reader));
    }

    @Deprecated
    public <T> void registerReader(Predicate<Class<?>> predicate, Reader<T> reader) {
        this.readers.registerFirst(new ReaderAdapter<T>(predicate, reader));
    }

    public <T> Single<T> unmarshall(Flow.Publisher<DataChunk> payload, GenericType<T> type) {
        if (payload == null) {
            return Single.empty();
        }
        if (Flow.Publisher.class.isAssignableFrom(type.rawType())) {
            throw new IllegalStateException("This method does not support unmarshalling of Flow.Publisher. Please use a stream unmarshalling method.");
        }
        try {
            Flow.Publisher<DataChunk> filteredPayload = this.applyFilters(payload, type);
            if (byte[].class.equals((Object)type.rawType())) {
                return ContentReaders.readBytes(filteredPayload);
            }
            MessageBodyReader<?> reader = this.readers.select(type, this);
            if (reader == null) {
                return MessageBodyReaderContext.readerNotFound(type.getTypeName());
            }
            return reader.read(filteredPayload, type, this);
        }
        catch (Throwable ex) {
            return MessageBodyReaderContext.transformationFailed(ex);
        }
    }

    public <T> Single<T> unmarshall(Flow.Publisher<DataChunk> payload, MessageBodyReader<T> reader, GenericType<T> type) {
        Objects.requireNonNull(reader);
        if (payload == null) {
            return Single.empty();
        }
        if (Flow.Publisher.class.isAssignableFrom(type.rawType())) {
            throw new IllegalStateException("This method does not support unmarshalling of Flow.Publisher. Please use a stream unmarshalling method.");
        }
        try {
            Flow.Publisher<DataChunk> filteredPayload = this.applyFilters(payload, type);
            return reader.read(filteredPayload, type, this);
        }
        catch (Throwable ex) {
            return MessageBodyReaderContext.transformationFailed(ex);
        }
    }

    public <T> Flow.Publisher<T> unmarshallStream(Flow.Publisher<DataChunk> payload, GenericType<T> type) {
        if (payload == null) {
            return Multi.empty();
        }
        try {
            Flow.Publisher<DataChunk> filteredPayload = this.applyFilters(payload, type);
            MessageBodyStreamReader<?> reader = this.sreaders.select(type, this);
            if (reader == null) {
                return MessageBodyReaderContext.readerNotFound(type.getTypeName());
            }
            return reader.read(filteredPayload, type, this);
        }
        catch (Throwable ex) {
            return MessageBodyReaderContext.transformationFailed(ex);
        }
    }

    public <T> Flow.Publisher<T> unmarshallStream(Flow.Publisher<DataChunk> payload, MessageBodyStreamReader<T> reader, GenericType<T> type) {
        Objects.requireNonNull(reader);
        if (payload == null) {
            return Multi.empty();
        }
        try {
            Flow.Publisher<DataChunk> filteredPayload = this.applyFilters(payload, type);
            return reader.read(filteredPayload, type, this);
        }
        catch (Throwable ex) {
            return MessageBodyReaderContext.transformationFailed(ex);
        }
    }

    public ReadOnlyParameters headers() {
        return this.headers;
    }

    public Optional<MediaType> contentType() {
        return this.contentType;
    }

    @Override
    public Charset charset() throws IllegalStateException {
        if (this.contentType.isPresent()) {
            try {
                return this.contentType.get().charset().map(Charset::forName).orElse(DEFAULT_CHARSET);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return DEFAULT_CHARSET;
    }

    public static MessageBodyReaderContext create(MessageBodyReaderContext parent) {
        return new MessageBodyReaderContext(parent);
    }

    public static MessageBodyReaderContext create(MediaContext mediaContext, MessageBodyContext.EventListener eventListener, ReadOnlyParameters headers, Optional<MediaType> contentType) {
        if (mediaContext == null) {
            return new MessageBodyReaderContext(null, eventListener, headers, contentType);
        }
        return new MessageBodyReaderContext(mediaContext.readerContext(), eventListener, headers, contentType);
    }

    public static MessageBodyReaderContext create(MessageBodyReaderContext parent, MessageBodyContext.EventListener eventListener, ReadOnlyParameters headers, Optional<MediaType> contentType) {
        return new MessageBodyReaderContext(parent, eventListener, headers, contentType);
    }

    private static <T> Single<T> readerNotFound(String type) {
        return Single.error((Throwable)new IllegalStateException("No reader found for type: " + type));
    }

    private static <T> Single<T> transformationFailed(Throwable ex) {
        return Single.error((Throwable)new IllegalStateException("Transformation failed!", ex));
    }

    private static final class ReaderAdapter<T>
    implements MessageBodyReader<T> {
        private final Reader<T> reader;
        private final Predicate<Class<?>> predicate;
        private final Class<T> clazz;

        ReaderAdapter(Predicate<Class<?>> predicate, Reader<T> reader) {
            Objects.requireNonNull(predicate, "predicate cannot be null!");
            Objects.requireNonNull(reader, "reader cannot be null!");
            this.reader = reader;
            this.predicate = predicate;
            this.clazz = null;
        }

        ReaderAdapter(Class<T> clazz, Reader<T> reader) {
            Objects.requireNonNull(clazz, "clazz cannot be null!");
            Objects.requireNonNull(reader, "reader cannot be null!");
            this.reader = reader;
            this.clazz = clazz;
            this.predicate = null;
        }

        @Override
        public <U extends T> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
            return Single.create((CompletionStage)this.reader.applyAndCast(publisher, type.rawType()));
        }

        @Override
        public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
            if (this.predicate != null) {
                return this.predicate.test(type.rawType()) ? MessageBodyOperator.PredicateResult.SUPPORTED : MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
            }
            return MessageBodyOperator.PredicateResult.supports(this.clazz, type);
        }
    }
}

