/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;

final class CharSequenceBodyStreamWriter
implements MessageBodyStreamWriter<CharSequence> {
    private static final CharSequenceBodyStreamWriter DEFAULT = new CharSequenceBodyStreamWriter();

    private CharSequenceBodyStreamWriter() {
    }

    static CharSequenceBodyStreamWriter create() {
        return DEFAULT;
    }

    @Override
    public Flow.Publisher<DataChunk> write(Flow.Publisher<? extends CharSequence> publisher, GenericType<? extends CharSequence> type, MessageBodyWriterContext context) {
        context.contentType(MediaType.TEXT_PLAIN);
        return Multi.create(publisher).map(s -> DataChunk.create((boolean)true, (ByteBuffer[])new ByteBuffer[]{context.charset().encode(s.toString())}));
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(CharSequence.class, type);
    }
}

