/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.FormParams;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.config.Config;
import io.helidon.media.common.ByteChannelBodyWriter;
import io.helidon.media.common.CharSequenceBodyStreamWriter;
import io.helidon.media.common.CharSequenceBodyWriter;
import io.helidon.media.common.FileBodyWriter;
import io.helidon.media.common.FormParamsBodyReader;
import io.helidon.media.common.FormParamsBodyWriter;
import io.helidon.media.common.InputStreamBodyReader;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.PathBodyWriter;
import io.helidon.media.common.StringBodyReader;
import io.helidon.media.common.ThrowableBodyWriter;
import java.io.File;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DefaultMediaSupport
implements MediaSupport {
    private final ByteChannelBodyWriter byteChannelBodyWriter;
    private final ThrowableBodyWriter throwableBodyWriter;

    private DefaultMediaSupport(Builder builder) {
        this.byteChannelBodyWriter = builder.schema == null ? ByteChannelBodyWriter.create() : ByteChannelBodyWriter.create(builder.schema);
        this.throwableBodyWriter = ThrowableBodyWriter.create(builder.includeStackTraces);
    }

    public static DefaultMediaSupport create() {
        return DefaultMediaSupport.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MessageBodyReader<String> stringReader() {
        return StringBodyReader.create();
    }

    public static MessageBodyReader<InputStream> inputStreamReader() {
        return InputStreamBodyReader.create();
    }

    public static MessageBodyWriter<CharSequence> charSequenceWriter() {
        return CharSequenceBodyWriter.create();
    }

    public static MessageBodyStreamWriter<CharSequence> charSequenceStreamWriter() {
        return CharSequenceBodyStreamWriter.create();
    }

    public static MessageBodyWriter<ReadableByteChannel> byteChannelWriter() {
        return ByteChannelBodyWriter.create();
    }

    public static MessageBodyWriter<ReadableByteChannel> byteChannelWriter(RetrySchema schema) {
        return ByteChannelBodyWriter.create(schema);
    }

    public static MessageBodyWriter<Path> pathWriter() {
        return PathBodyWriter.create();
    }

    public static MessageBodyWriter<File> fileWriter() {
        return FileBodyWriter.create();
    }

    public static MessageBodyWriter<FormParams> formParamWriter() {
        return FormParamsBodyWriter.create();
    }

    public static MessageBodyReader<FormParams> formParamReader() {
        return FormParamsBodyReader.create();
    }

    public static MessageBodyWriter<Throwable> throwableWriter(boolean includeStackTraces) {
        return ThrowableBodyWriter.create(includeStackTraces);
    }

    @Override
    public Collection<MessageBodyReader<?>> readers() {
        return List.of(DefaultMediaSupport.stringReader(), DefaultMediaSupport.inputStreamReader(), DefaultMediaSupport.formParamReader());
    }

    @Override
    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(DefaultMediaSupport.charSequenceWriter(), this.byteChannelBodyWriter, DefaultMediaSupport.pathWriter(), DefaultMediaSupport.fileWriter(), this.throwableBodyWriter, DefaultMediaSupport.formParamWriter());
    }

    @Override
    public Collection<MessageBodyStreamWriter<?>> streamWriters() {
        return List.of(DefaultMediaSupport.charSequenceStreamWriter());
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, DefaultMediaSupport> {
        private boolean includeStackTraces = false;
        private RetrySchema schema;

        private Builder() {
        }

        public DefaultMediaSupport build() {
            return new DefaultMediaSupport(this);
        }

        public Builder includeStackTraces(boolean includeStackTraces) {
            this.includeStackTraces = includeStackTraces;
            return this;
        }

        public Builder byteChannelRetrySchema(RetrySchema schema) {
            this.schema = Objects.requireNonNull(schema);
            return this;
        }

        public Builder config(Config config) {
            config.get("include-stack-traces").asBoolean().ifPresent(this::includeStackTraces);
            return this;
        }
    }
}

