/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.HashHeaders;
import io.helidon.common.http.Headers;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.ReadOnlyHeaders;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyFilters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyOperators;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriters;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MessageBodyWriterContext
extends MessageBodyContext
implements MessageBodyWriters,
MessageBodyFilters {
    private static final BytesMapper BYTES_MAPPER = new BytesMapper();
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Headers headers;
    private final List<MediaType> acceptedTypes;
    private final MessageBodyOperators<MessageBodyWriter<?>> writers;
    private final MessageBodyOperators<MessageBodyStreamWriter<?>> swriters;
    private boolean contentTypeCached;
    private Optional<MediaType> contentTypeCache;
    private boolean charsetCached;
    private Charset charsetCache;

    private MessageBodyWriterContext(MessageBodyWriterContext parent, MessageBodyContext.EventListener eventListener, Headers headers, List<MediaType> acceptedTypes) {
        super(parent, eventListener);
        Objects.requireNonNull(headers, "headers cannot be null!");
        this.headers = headers;
        this.acceptedTypes = acceptedTypes != null ? acceptedTypes : List.of();
        if (parent != null) {
            this.writers = new MessageBodyOperators(parent.writers);
            this.swriters = new MessageBodyOperators(parent.swriters);
        } else {
            this.writers = new MessageBodyOperators();
            this.swriters = new MessageBodyOperators();
        }
    }

    private MessageBodyWriterContext(Headers headers) {
        super(null, null);
        Objects.requireNonNull(headers, "headers cannot be null!");
        this.headers = headers;
        this.writers = new MessageBodyOperators();
        this.swriters = new MessageBodyOperators();
        this.acceptedTypes = List.of();
    }

    private MessageBodyWriterContext() {
        super(null, null);
        this.headers = ReadOnlyHeaders.empty();
        this.writers = new MessageBodyOperators();
        this.swriters = new MessageBodyOperators();
        this.acceptedTypes = List.of();
        this.contentTypeCache = Optional.empty();
        this.contentTypeCached = true;
        this.charsetCache = DEFAULT_CHARSET;
        this.charsetCached = true;
    }

    private MessageBodyWriterContext(MessageBodyWriterContext writerContext, Headers headers) {
        super(writerContext);
        Objects.requireNonNull(headers, "headers cannot be null!");
        this.headers = headers;
        this.writers = new MessageBodyOperators(writerContext.writers);
        this.swriters = new MessageBodyOperators(writerContext.swriters);
        this.acceptedTypes = writerContext.acceptedTypes;
        this.contentTypeCache = writerContext.contentTypeCache;
        this.contentTypeCached = writerContext.contentTypeCached;
        this.charsetCache = writerContext.charsetCache;
        this.charsetCached = writerContext.charsetCached;
    }

    @Deprecated(since="3.0.3", forRemoval=true)
    public static MessageBodyWriterContext create(MediaContext mediaContext, MessageBodyContext.EventListener eventListener, Parameters headers, List<MediaType> acceptedTypes) {
        return MessageBodyWriterContext.create(mediaContext, eventListener, (Headers)HashHeaders.create((Parameters)headers), acceptedTypes);
    }

    public static MessageBodyWriterContext create(MediaContext mediaContext, MessageBodyContext.EventListener eventListener, Headers headers, List<MediaType> acceptedTypes) {
        if (mediaContext == null) {
            return new MessageBodyWriterContext(null, eventListener, headers, acceptedTypes);
        }
        return new MessageBodyWriterContext(mediaContext.writerContext(), eventListener, headers, acceptedTypes);
    }

    @Deprecated(since="3.0.3", forRemoval=true)
    public static MessageBodyWriterContext create(MessageBodyWriterContext parent, MessageBodyContext.EventListener eventListener, Parameters headers, List<MediaType> acceptedTypes) {
        return MessageBodyWriterContext.create(parent, eventListener, (Headers)HashHeaders.create((Parameters)headers), acceptedTypes);
    }

    public static MessageBodyWriterContext create(MessageBodyWriterContext parent, MessageBodyContext.EventListener eventListener, Headers headers, List<MediaType> acceptedTypes) {
        return new MessageBodyWriterContext(parent, eventListener, headers, acceptedTypes);
    }

    @Deprecated(since="3.0.3", forRemoval=true)
    public static MessageBodyWriterContext create(Parameters headers) {
        return MessageBodyWriterContext.create((Headers)HashHeaders.create((Parameters)headers));
    }

    public static MessageBodyWriterContext create(Headers headers) {
        return new MessageBodyWriterContext(headers);
    }

    public static MessageBodyWriterContext create(MessageBodyWriterContext parent) {
        return new MessageBodyWriterContext(parent, parent.headers);
    }

    @Deprecated(since="3.0.3", forRemoval=true)
    public static MessageBodyWriterContext create(MessageBodyWriterContext parent, Parameters headers) {
        return MessageBodyWriterContext.create(parent, (Headers)HashHeaders.create((Parameters)headers));
    }

    public static MessageBodyWriterContext create(MessageBodyWriterContext parent, Headers headers) {
        return new MessageBodyWriterContext(parent, headers);
    }

    public static MessageBodyWriterContext create() {
        return new MessageBodyWriterContext((Headers)ReadOnlyHeaders.empty());
    }

    @Override
    public MessageBodyWriterContext registerWriter(MessageBodyWriter<?> writer) {
        this.writers.registerFirst(writer);
        return this;
    }

    @Override
    public MessageBodyWriterContext registerWriter(MessageBodyStreamWriter<?> writer) {
        this.swriters.registerFirst(writer);
        return this;
    }

    @Deprecated
    public <T> MessageBodyWriterContext registerWriter(Class<T> type, Function<T, Flow.Publisher<DataChunk>> function) {
        this.writers.registerFirst(new WriterAdapter<T>(function, type, null));
        return this;
    }

    @Deprecated
    public <T> MessageBodyWriterContext registerWriter(Class<T> type, MediaType contentType, Function<? extends T, Flow.Publisher<DataChunk>> function) {
        this.writers.registerFirst(new WriterAdapter<T>(function, type, contentType));
        return this;
    }

    @Deprecated
    public <T> MessageBodyWriterContext registerWriter(Predicate<?> accept, Function<T, Flow.Publisher<DataChunk>> function) {
        this.writers.registerFirst(new WriterAdapter<T>(function, accept, null));
        return this;
    }

    @Deprecated
    public <T> MessageBodyWriterContext registerWriter(Predicate<?> accept, MediaType contentType, Function<T, Flow.Publisher<DataChunk>> function) {
        this.writers.registerFirst(new WriterAdapter<T>(function, accept, contentType));
        return this;
    }

    public <T> Flow.Publisher<DataChunk> marshall(Single<T> content, GenericType<T> type) {
        try {
            if (content == null) {
                return this.applyFilters((Flow.Publisher<DataChunk>)Multi.empty());
            }
            if (byte[].class.equals((Object)type.rawType())) {
                return this.applyFilters((Flow.Publisher<DataChunk>)content.flatMap((Function)((Object)BYTES_MAPPER)));
            }
            if (Flow.Publisher.class.isAssignableFrom(type.rawType())) {
                throw new IllegalStateException("This method does not support marshalling of Flow.Publisher. Please use a method that accepts Flow.Publisher and type for stream marshalling.");
            }
            MessageBodyWriter<?> writer = this.writers.select(type, this);
            if (writer == null) {
                throw new IllegalStateException("No writer found for type: " + type + ". This usually occurs when the appropriate MediaSupport has not been added.");
            }
            return this.applyFilters(writer.write(content, type, this));
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Transformation failed!", ex);
        }
    }

    public <T> Flow.Publisher<DataChunk> marshall(Single<T> content, MessageBodyWriter<T> writer, GenericType<T> type) {
        Objects.requireNonNull(writer);
        try {
            if (content == null) {
                return this.applyFilters((Flow.Publisher<DataChunk>)Multi.empty());
            }
            return this.applyFilters(writer.write(content, type, this));
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Transformation failed!", ex);
        }
    }

    public <T> Flow.Publisher<DataChunk> marshallStream(Flow.Publisher<T> content, GenericType<T> type) {
        try {
            if (content == null) {
                return this.applyFilters((Flow.Publisher<DataChunk>)Multi.empty());
            }
            MessageBodyStreamWriter<?> writer = this.swriters.select(type, this);
            if (writer == null) {
                throw new IllegalStateException("No stream writer found for type: " + type + ". This usually occurs when the appropriate MediaSupport has not been added.");
            }
            return this.applyFilters(writer.write(content, type, this));
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Transformation failed!", ex);
        }
    }

    public <T> Flow.Publisher<DataChunk> marshallStream(Flow.Publisher<T> content, MessageBodyStreamWriter<T> writer, GenericType<T> type) {
        Objects.requireNonNull(writer);
        try {
            if (content == null) {
                return this.applyFilters((Flow.Publisher<DataChunk>)Multi.empty());
            }
            return this.applyFilters(writer.write(content, type, this));
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Transformation failed!", ex);
        }
    }

    public Headers headers() {
        return this.headers;
    }

    public Optional<MediaType> contentType() {
        if (this.contentTypeCached) {
            return this.contentTypeCache;
        }
        this.contentTypeCache = Optional.ofNullable(this.headers.first("Content-Type").map(MediaType::parse).orElse(null));
        this.contentTypeCached = true;
        return this.contentTypeCache;
    }

    public List<MediaType> acceptedTypes() {
        return this.acceptedTypes;
    }

    public void contentType(MediaType contentType) {
        if (contentType != null) {
            this.headers.putIfAbsent("Content-Type", new String[]{contentType.toString()});
        }
    }

    public void contentLength(long contentLength) {
        if (contentLength >= 0L) {
            this.headers.putIfAbsent("Content-Length", new String[]{String.valueOf(contentLength)});
        }
    }

    public MediaType findAccepted(Predicate<MediaType> predicate, MediaType defaultType) throws IllegalStateException {
        Objects.requireNonNull(predicate, "predicate cannot be null");
        Objects.requireNonNull(defaultType, "defaultType cannot be null");
        MediaType contentType = this.contentType().orElse(null);
        if (contentType == null) {
            if (this.acceptedTypes.isEmpty()) {
                return defaultType;
            }
            for (MediaType acceptedType : this.acceptedTypes) {
                if (!predicate.test(acceptedType)) continue;
                if (acceptedType.isWildcardType() || acceptedType.isWildcardSubtype()) {
                    return defaultType;
                }
                return MediaType.create((String)acceptedType.type(), (String)acceptedType.subtype());
            }
        } else if (predicate.test(contentType)) {
            return contentType;
        }
        throw new IllegalStateException("No accepted Content-Type");
    }

    public MediaType findAccepted(MediaType mediaType) throws IllegalStateException {
        Objects.requireNonNull(mediaType, "mediaType cannot be null");
        for (MediaType acceptedType : this.acceptedTypes) {
            if (!mediaType.equals((Object)acceptedType)) continue;
            return acceptedType;
        }
        throw new IllegalStateException("No accepted Content-Type");
    }

    @Override
    public Charset charset() throws IllegalStateException {
        if (this.charsetCached) {
            return this.charsetCache;
        }
        MediaType contentType = this.contentType().orElse(null);
        if (contentType != null) {
            try {
                this.charsetCache = contentType.charset().map(Charset::forName).orElse(DEFAULT_CHARSET);
                this.charsetCached = true;
                return this.charsetCache;
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.charsetCache = DEFAULT_CHARSET;
        this.charsetCached = true;
        return this.charsetCache;
    }

    private static final class WriterAdapter<T>
    implements MessageBodyWriter<T> {
        private final Function<T, Flow.Publisher<DataChunk>> function;
        private final Predicate predicate;
        private final Class<T> type;
        private final MediaType contentType;

        WriterAdapter(Function<T, Flow.Publisher<DataChunk>> function, Predicate<?> predicate, MediaType contentType) {
            Objects.requireNonNull(function, "function cannot be null!");
            Objects.requireNonNull(predicate, "predicate cannot be null!");
            this.function = function;
            this.predicate = predicate;
            this.contentType = contentType;
            this.type = null;
        }

        WriterAdapter(Function<? extends T, Flow.Publisher<DataChunk>> function, Class<T> type, MediaType contentType) {
            Objects.requireNonNull(function, "function cannot be null!");
            Objects.requireNonNull(type, "type cannot be null!");
            this.function = function;
            this.type = type;
            this.contentType = contentType;
            this.predicate = null;
        }

        @Override
        public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
            if (this.type != null ? !this.type.isAssignableFrom(type.rawType()) : !this.predicate.test(type.rawType())) {
                return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
            }
            MediaType ct = context.contentType().orElse(null);
            if (this.contentType == null || ct == null || ct.test(this.contentType)) {
                context.contentType(this.contentType);
                return MessageBodyOperator.PredicateResult.SUPPORTED;
            }
            return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
        }

        @Override
        public Flow.Publisher<DataChunk> write(Single<? extends T> single, GenericType<? extends T> type, MessageBodyWriterContext context) {
            return single.flatMap(this.function);
        }
    }

    private static final class BytesMapper
    implements Mapper<byte[], Flow.Publisher<DataChunk>> {
        private BytesMapper() {
        }

        public Flow.Publisher<DataChunk> map(byte[] item) {
            return ContentWriters.writeBytes(item, false);
        }
    }
}

