/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Flow;
import java.util.function.Function;

class ThrowableBodyWriter
implements MessageBodyWriter<Throwable> {
    private static final ThrowableBodyWriter DEFAULT_TRUE = new ThrowableBodyWriter(true);
    private static final ThrowableBodyWriter DEFAULT_FALSE = new ThrowableBodyWriter(false);
    private final boolean includeStackTraces;

    private ThrowableBodyWriter() {
        this(false);
    }

    protected ThrowableBodyWriter(boolean includeStackTraces) {
        this.includeStackTraces = includeStackTraces;
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(Throwable.class, type);
    }

    @Override
    public Flow.Publisher<DataChunk> write(Single<? extends Throwable> content, GenericType<? extends Throwable> type, MessageBodyWriterContext context) {
        context.contentType(MediaType.TEXT_PLAIN);
        if (this.includeStackTraces) {
            return content.flatMap((Function)((Object)new ThrowableToChunks(context.charset())));
        }
        return ContentWriters.writeCharSequence("Unexpected exception occurred.", StandardCharsets.UTF_8);
    }

    static ThrowableBodyWriter create(boolean includeStackTraces) {
        return includeStackTraces ? DEFAULT_TRUE : DEFAULT_FALSE;
    }

    private static final class ThrowableToChunks
    implements Mapper<Throwable, Flow.Publisher<DataChunk>> {
        private final Charset charset;

        private ThrowableToChunks(Charset charset) {
            this.charset = charset;
        }

        public Flow.Publisher<DataChunk> map(Throwable throwable) {
            return ContentWriters.writeStackTrace(throwable, this.charset);
        }
    }
}

