/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.helidon.config.Config;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.spi.MediaSupportProvider;
import io.helidon.media.jackson.JacksonSupport;
import java.util.stream.Stream;

public class JacksonProvider
implements MediaSupportProvider {
    private static final String JACKSON = "jackson";

    public MediaSupport create(Config config) {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        this.configureJackson(objectMapper, config);
        return JacksonSupport.create(objectMapper);
    }

    private void configureJackson(ObjectMapper objectMapper, Config config) {
        Stream.of(DeserializationFeature.values()).forEach(df -> config.get(this.configName(df.name())).asBoolean().ifPresent(val -> objectMapper.configure(df, val.booleanValue())));
        Stream.of(SerializationFeature.values()).forEach(sf -> config.get(this.configName(sf.name())).asBoolean().ifPresent(val -> objectMapper.configure(sf, val.booleanValue())));
        Stream.of(JsonParser.Feature.values()).forEach(jp -> config.get(this.configName(jp.name())).asBoolean().ifPresent(val -> objectMapper.configure(jp, val.booleanValue())));
        Stream.of(MapperFeature.values()).forEach(mf -> config.get(this.configName(mf.name())).asBoolean().ifPresent(val -> objectMapper.configure(mf, val.booleanValue())));
        Stream.of(JsonGenerator.Feature.values()).forEach(jgf -> config.get(this.configName(jgf.name())).asBoolean().ifPresent(val -> objectMapper.configure(jgf, val.booleanValue())));
    }

    private String configName(String enumName) {
        return enumName.toLowerCase().replace('_', '-');
    }

    public String configKey() {
        return JACKSON;
    }
}

