/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.helidon.common.LazyValue;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jackson.JacksonBodyReader;
import io.helidon.media.jackson.JacksonBodyStreamWriter;
import io.helidon.media.jackson.JacksonBodyWriter;
import io.helidon.media.jackson.JacksonEsBodyStreamWriter;
import io.helidon.media.jackson.JacksonNdBodyStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class JacksonSupport
implements MediaSupport {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
    private static final LazyValue<JacksonSupport> DEFAULT = LazyValue.create(() -> new JacksonSupport(MAPPER));
    private final JacksonBodyReader reader;
    private final JacksonBodyWriter writer;
    private final JacksonBodyStreamWriter streamWriter;
    private final JacksonEsBodyStreamWriter esStreamWriter;
    private final JacksonNdBodyStreamWriter ndStreamWriter;

    private JacksonSupport(ObjectMapper objectMapper) {
        this.reader = JacksonBodyReader.create(objectMapper);
        this.writer = JacksonBodyWriter.create(objectMapper);
        this.streamWriter = JacksonBodyStreamWriter.create(objectMapper);
        this.esStreamWriter = JacksonEsBodyStreamWriter.create(objectMapper);
        this.ndStreamWriter = JacksonNdBodyStreamWriter.create(objectMapper);
    }

    public static JacksonSupport create() {
        return (JacksonSupport)DEFAULT.get();
    }

    public static JacksonSupport create(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return new JacksonSupport(objectMapper);
    }

    public static MessageBodyReader<Object> reader() {
        return ((JacksonSupport)JacksonSupport.DEFAULT.get()).reader;
    }

    public static MessageBodyReader<Object> reader(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return JacksonBodyReader.create(objectMapper);
    }

    public static MessageBodyWriter<Object> writer() {
        return ((JacksonSupport)JacksonSupport.DEFAULT.get()).writer;
    }

    public static MessageBodyWriter<Object> writer(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return JacksonBodyWriter.create(objectMapper);
    }

    public static MessageBodyStreamWriter<Object> streamWriter() {
        return ((JacksonSupport)JacksonSupport.DEFAULT.get()).streamWriter;
    }

    public static MessageBodyStreamWriter<Object> streamWriter(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return JacksonEsBodyStreamWriter.create(objectMapper);
    }

    public static MessageBodyStreamWriter<Object> eventStreamWriter() {
        return ((JacksonSupport)JacksonSupport.DEFAULT.get()).esStreamWriter;
    }

    public static MessageBodyStreamWriter<Object> eventStreamWriter(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return JacksonEsBodyStreamWriter.create(objectMapper);
    }

    public static MessageBodyStreamWriter<Object> ndJsonStreamWriter() {
        return ((JacksonSupport)JacksonSupport.DEFAULT.get()).ndStreamWriter;
    }

    public static MessageBodyStreamWriter<Object> ndJsonStreamWriter(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return JacksonNdBodyStreamWriter.create(objectMapper);
    }

    public MessageBodyReader<Object> readerInstance() {
        return this.reader;
    }

    public MessageBodyWriter<Object> writerInstance() {
        return this.writer;
    }

    public MessageBodyStreamWriter<Object> streamWriterInstance() {
        return this.streamWriter;
    }

    public MessageBodyStreamWriter<Object> eventStreamWriterInstance() {
        return this.esStreamWriter;
    }

    public MessageBodyStreamWriter<Object> ndJsonStreamWriterInstance() {
        return this.ndStreamWriter;
    }

    public Collection<MessageBodyReader<?>> readers() {
        return List.of(this.reader);
    }

    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(this.writer);
    }

    public Collection<MessageBodyStreamWriter<?>> streamWriters() {
        return List.of(this.streamWriter, this.ndStreamWriter, this.esStreamWriter);
    }
}

