/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.jackson.JacksonRuntimeException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.Flow;

final class JacksonBodyReader
implements MessageBodyReader<Object> {
    private final ObjectMapper objectMapper;

    private JacksonBodyReader(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        Class clazz = type.rawType();
        return !CharSequence.class.isAssignableFrom(clazz) && this.objectMapper.canDeserialize(this.objectMapper.constructType((Type)clazz)) ? MessageBodyOperator.PredicateResult.COMPATIBLE : MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
    }

    public <U> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        return ContentReaders.readBytes(publisher).map(new BytesToObject<U>(type, this.objectMapper));
    }

    public static JacksonBodyReader create(ObjectMapper objectMapper) {
        return new JacksonBodyReader(objectMapper);
    }

    private static final class BytesToObject<T>
    implements Mapper<byte[], T> {
        private final GenericType<? super T> type;
        private final ObjectMapper objectMapper;

        BytesToObject(GenericType<T> type, ObjectMapper objectMapper) {
            this.type = type;
            this.objectMapper = objectMapper;
        }

        public T map(byte[] bytes) {
            try {
                Type t = this.type.type();
                if (t instanceof ParameterizedType) {
                    TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                    ParameterizedType pt = (ParameterizedType)t;
                    JavaType javaType = typeFactory.constructType((Type)pt);
                    return (T)this.objectMapper.readValue(bytes, javaType);
                }
                return (T)this.objectMapper.readValue(bytes, this.type.rawType());
            }
            catch (IOException wrapMe) {
                throw new JacksonRuntimeException(wrapMe.getMessage(), wrapMe);
            }
        }
    }
}

