/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jackson.JacksonBodyWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

class JacksonBodyStreamWriter
implements MessageBodyStreamWriter<Object> {
    private static final byte[] ARRAY_JSON_END_BYTES = "]".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ARRAY_JSON_BEGIN_BYTES = "[".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMA_BYTES = ",".getBytes(StandardCharsets.UTF_8);
    private final ObjectMapper objectMapper;

    private JacksonBodyStreamWriter(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    static JacksonBodyStreamWriter create(ObjectMapper objectMapper) {
        return new JacksonBodyStreamWriter(objectMapper);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return !CharSequence.class.isAssignableFrom(type.rawType()) ? MessageBodyOperator.PredicateResult.COMPATIBLE : MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
    }

    public Multi<DataChunk> write(Flow.Publisher<?> publisher, GenericType<?> type, MessageBodyWriterContext context) {
        MediaType contentType = context.findAccepted(MediaType.JSON_PREDICATE, MediaType.APPLICATION_JSON);
        context.contentType(contentType);
        AtomicBoolean first = new AtomicBoolean(true);
        JacksonBodyWriter.ObjectToChunks objectToChunks = new JacksonBodyWriter.ObjectToChunks(this.objectMapper, context.charset());
        return Multi.create(publisher).flatMap((Function)((Object)objectToChunks)).flatMap(it -> {
            if (first.getAndSet(false)) {
                return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])ARRAY_JSON_BEGIN_BYTES), it});
            }
            return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])COMMA_BYTES), it});
        }).onCompleteResume((Object)DataChunk.create((byte[])ARRAY_JSON_END_BYTES));
    }
}

