/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jackson.JacksonBodyWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;

class JacksonEsBodyStreamWriter
implements MessageBodyStreamWriter<Object> {
    private static final MediaType TEXT_EVENT_STREAM_JSON = MediaType.parse((String)"text/event-stream;element-type=\"application/json\"");
    private static final byte[] DATA = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NL = "\n\n".getBytes(StandardCharsets.UTF_8);
    private final ObjectMapper objectMapper;

    private JacksonEsBodyStreamWriter(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    static JacksonEsBodyStreamWriter create(ObjectMapper objectMapper) {
        return new JacksonEsBodyStreamWriter(objectMapper);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        if (CharSequence.class.isAssignableFrom(type.rawType())) {
            return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
        }
        return context.contentType().or(() -> this.findMediaType(context)).map(it -> MessageBodyOperator.PredicateResult.COMPATIBLE).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    public Multi<DataChunk> write(Flow.Publisher<?> publisher, GenericType<?> type, MessageBodyWriterContext context) {
        MediaType contentType = context.contentType().or(() -> this.findMediaType(context)).orElse(TEXT_EVENT_STREAM_JSON);
        context.contentType(contentType);
        JacksonBodyWriter.ObjectToChunks objectToChunks = new JacksonBodyWriter.ObjectToChunks(this.objectMapper, context.charset());
        return Multi.create(publisher).flatMap((Function)((Object)objectToChunks)).flatMap(chunk -> Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])DATA), chunk, DataChunk.create((byte[])NL)}));
    }

    private Optional<MediaType> findMediaType(MessageBodyWriterContext context) {
        try {
            return Optional.of(context.findAccepted(MediaType.JSON_EVENT_STREAM_PREDICATE, TEXT_EVENT_STREAM_JSON));
        }
        catch (IllegalStateException ignore) {
            return Optional.empty();
        }
    }
}

