/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.Flow;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;

class JsonbBodyReader
implements MessageBodyReader<Object> {
    private final Jsonb jsonb;

    private JsonbBodyReader(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        this.jsonb = jsonb;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        return !CharSequence.class.isAssignableFrom(type.rawType()) ? MessageBodyOperator.PredicateResult.COMPATIBLE : MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
    }

    public <U> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        return ContentReaders.readBytes(publisher).map(new BytesToObject<U>(type, this.jsonb));
    }

    public static JsonbBodyReader create(Jsonb jsonb) {
        return new JsonbBodyReader(jsonb);
    }

    private static final class BytesToObject<T>
    implements Mapper<byte[], T> {
        private final GenericType<? super T> type;
        private final Jsonb jsonb;

        BytesToObject(GenericType<? super T> type, Jsonb jsonb) {
            this.type = type;
            this.jsonb = jsonb;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T map(byte[] bytes) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                Object object = this.jsonb.fromJson((InputStream)inputStream, this.type.type());
                return (T)object;
            }
            catch (IOException ex) {
                throw new JsonbException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

