/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jsonp.JsonpBodyWriter;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriterFactory;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;

class JsonpEsBodyStreamWriter
implements MessageBodyStreamWriter<JsonStructure> {
    private static final MediaType TEXT_EVENT_STREAM_JSON = MediaType.parse((String)"text/event-stream;element-type=\"application/json\"");
    private static final byte[] DATA = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NL = "\n\n".getBytes(StandardCharsets.UTF_8);
    private final JsonWriterFactory jsonWriterFactory;

    JsonpEsBodyStreamWriter(JsonWriterFactory jsonWriterFactory) {
        this.jsonWriterFactory = Objects.requireNonNull(jsonWriterFactory);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        if (!JsonStructure.class.isAssignableFrom(type.rawType())) {
            return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
        }
        return context.contentType().or(() -> this.findMediaType(context)).map(it -> MessageBodyOperator.PredicateResult.COMPATIBLE).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    public Multi<DataChunk> write(Flow.Publisher<? extends JsonStructure> publisher, GenericType<? extends JsonStructure> type, MessageBodyWriterContext context) {
        MediaType contentType = context.contentType().or(() -> this.findMediaType(context)).orElse(TEXT_EVENT_STREAM_JSON);
        context.contentType(contentType);
        JsonpBodyWriter.JsonStructureToChunks jsonToChunks = new JsonpBodyWriter.JsonStructureToChunks(true, this.jsonWriterFactory, context.charset());
        return Multi.create(publisher).map((Function)((Object)jsonToChunks)).flatMap(dataChunk -> Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])DATA), dataChunk, DataChunk.create((byte[])NL)}));
    }

    private Optional<MediaType> findMediaType(MessageBodyWriterContext context) {
        try {
            return Optional.of(context.findAccepted(MediaType.JSON_EVENT_STREAM_PREDICATE, TEXT_EVENT_STREAM_JSON));
        }
        catch (IllegalStateException ignore) {
            return Optional.empty();
        }
    }
}

