/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyStreamReader;
import io.helidon.media.multipart.BodyPart;
import io.helidon.media.multipart.MultiPartDecoder;
import io.helidon.media.multipart.ReadableBodyPart;
import java.util.concurrent.Flow;

public final class BodyPartBodyStreamReader
implements MessageBodyStreamReader<ReadableBodyPart> {
    private BodyPartBodyStreamReader() {
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        return MessageBodyOperator.PredicateResult.supports(BodyPart.class, type);
    }

    public <U extends ReadableBodyPart> Flow.Publisher<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        String boundary = null;
        MediaType contentType = context.contentType().orElse(null);
        if (contentType != null) {
            boundary = (String)contentType.parameters().get("boundary");
        }
        if (boundary == null) {
            throw new IllegalStateException("boudary header is missing");
        }
        MultiPartDecoder decoder = MultiPartDecoder.create(boundary, context);
        publisher.subscribe(decoder);
        return decoder;
    }

    public static BodyPartBodyStreamReader create() {
        return new BodyPartBodyStreamReader();
    }
}

