/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.FormBuilder;
import io.helidon.media.multipart.FileFormParamsImpl;
import io.helidon.media.multipart.WriteableMultiPart;
import java.nio.file.Path;

public interface FileFormParams {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements FormBuilder<Builder, FileFormParams> {
        private final WriteableMultiPart.Builder builder = WriteableMultiPart.builder();

        private Builder() {
        }

        public FileFormParams build() {
            return new FileFormParamsImpl(this.builder.build().bodyParts());
        }

        public Builder add(String name, String ... values) {
            for (String value : values) {
                this.builder.bodyPart(name, value);
            }
            return this;
        }

        public Builder addFile(String name, String fileName, Path file) {
            this.builder.bodyPart(name, fileName, file);
            return this;
        }

        public Builder addFile(String name, Path ... files) {
            this.builder.bodyPart(name, files);
            return this;
        }
    }
}

