/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.multipart.MultiPartEncoder;
import io.helidon.media.multipart.WriteableMultiPart;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;

public final class MultiPartBodyWriter
implements MessageBodyWriter<WriteableMultiPart> {
    public static final String DEFAULT_BOUNDARY = "[^._.^]==>boundary<==[^._.^]";
    private final String boundary;

    private MultiPartBodyWriter(String boundary) {
        this.boundary = boundary;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return context.contentType().or(() -> Optional.of(MediaType.MULTIPART_FORM_DATA)).filter(mediaType -> mediaType == MediaType.MULTIPART_FORM_DATA).map(it -> MessageBodyOperator.PredicateResult.supports(WriteableMultiPart.class, (GenericType)type)).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    public Flow.Publisher<DataChunk> write(Single<? extends WriteableMultiPart> content, GenericType<? extends WriteableMultiPart> type, MessageBodyWriterContext context) {
        MediaType mediaType = MediaType.MULTIPART_FORM_DATA;
        MediaType mediaWithBoundary = MediaType.builder().type(mediaType.type()).subtype(mediaType.subtype()).addParameter("boundary", "\"" + this.boundary + "\"").build();
        context.headers().put("Content-Type", new String[]{mediaWithBoundary.toString()});
        return content.flatMap((Function)((Object)new MultiPartToChunks(this.boundary, context)));
    }

    public static MultiPartBodyWriter create(String boundary) {
        return new MultiPartBodyWriter(boundary);
    }

    public static MultiPartBodyWriter create() {
        return new MultiPartBodyWriter(DEFAULT_BOUNDARY);
    }

    private static final class MultiPartToChunks
    implements Mapper<WriteableMultiPart, Flow.Publisher<DataChunk>> {
        private final MultiPartEncoder encoder;

        MultiPartToChunks(String boundary, MessageBodyWriterContext context) {
            this.encoder = MultiPartEncoder.create(boundary, context);
        }

        public Flow.Publisher<DataChunk> map(WriteableMultiPart multiPart) {
            Multi.just(multiPart.bodyParts()).subscribe((Flow.Subscriber)this.encoder);
            return this.encoder;
        }
    }
}

