/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp.server;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Flow;
import io.helidon.media.common.ContentTypeCharset;
import io.helidon.media.jsonp.common.JsonProcessing;
import io.helidon.webserver.JsonService;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.nio.charset.Charset;
import java.util.function.Function;
import javax.json.JsonStructure;

public final class JsonSupport
extends JsonService {
    private static final JsonSupport INSTANCE = new JsonSupport(JsonProcessing.create());
    private final JsonProcessing processingSupport;

    private JsonSupport(JsonProcessing processing) {
        this.processingSupport = processing;
    }

    public void accept(ServerRequest request, ServerResponse response) {
        request.content().registerReader(JsonStructure.class::isAssignableFrom, (publisher, type) -> {
            Charset charset = ContentTypeCharset.determineCharset((Parameters)request.headers());
            return this.reader(charset).apply(publisher, type);
        });
        response.registerWriter(json -> json instanceof JsonStructure && this.acceptsJson(request, response), json -> {
            Charset charset = ContentTypeCharset.determineCharset((Parameters)response.headers());
            return this.writer(charset).apply((JsonStructure)json);
        });
        request.next();
    }

    public Reader<JsonStructure> reader(Charset charset) {
        return this.processingSupport.reader(charset);
    }

    public Reader<JsonStructure> reader() {
        return this.processingSupport.reader();
    }

    public Function<JsonStructure, Flow.Publisher<DataChunk>> writer(Charset charset) {
        return this.processingSupport.writer(charset);
    }

    public Function<JsonStructure, Flow.Publisher<DataChunk>> writer() {
        return this.processingSupport.writer();
    }

    public static JsonSupport create() {
        return INSTANCE;
    }

    public static JsonSupport create(JsonProcessing processing) {
        if (null == processing) {
            throw new NullPointerException("JsonProcessing argument must not be null.");
        }
        return new JsonSupport(processing);
    }
}

