/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaMessage;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;

class JakartaByteMessage
extends JakartaMessage
implements BytesMessage {
    private final javax.jms.BytesMessage delegate;

    JakartaByteMessage(javax.jms.BytesMessage delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public long getBodyLength() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).getBodyLength());
    }

    public boolean readBoolean() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readBoolean());
    }

    public byte readByte() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readByte());
    }

    public int readUnsignedByte() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readUnsignedByte());
    }

    public short readShort() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readShort());
    }

    public int readUnsignedShort() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readUnsignedShort());
    }

    public char readChar() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readChar()).charValue();
    }

    public int readInt() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readInt());
    }

    public long readLong() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readLong());
    }

    public float readFloat() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readFloat()).floatValue();
    }

    public double readDouble() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readDouble());
    }

    public String readUTF() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.BytesMessage)this.delegate).readUTF());
    }

    public int readBytes(byte[] value) throws JMSException {
        return ShimUtil.call(() -> this.delegate.readBytes(value));
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        return ShimUtil.call(() -> this.delegate.readBytes(value, length));
    }

    public void writeBoolean(boolean value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeBoolean(value));
    }

    public void writeByte(byte value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeByte(value));
    }

    public void writeShort(short value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeShort(value));
    }

    public void writeChar(char value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeChar(value));
    }

    public void writeInt(int value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeInt(value));
    }

    public void writeLong(long value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeLong(value));
    }

    public void writeFloat(float value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeFloat(value));
    }

    public void writeDouble(double value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeDouble(value));
    }

    public void writeUTF(String value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeUTF(value));
    }

    public void writeBytes(byte[] value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeBytes(value));
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeBytes(value, offset, length));
    }

    public void writeObject(Object value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeObject(value));
    }

    public void reset() throws JMSException {
        ShimUtil.run(() -> ((javax.jms.BytesMessage)this.delegate).reset());
    }
}

