/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import javax.jms.Connection;
import javax.jms.Topic;

class JakartaConnection
implements jakarta.jms.Connection {
    private final Connection connection;

    JakartaConnection(Connection connection) {
        this.connection = connection;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.connection.createSession(transacted, acknowledgeMode)));
    }

    public Session createSession(int sessionMode) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.connection.createSession(sessionMode)));
    }

    public Session createSession() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((Connection)this.connection).createSession()));
    }

    public String getClientID() throws JMSException {
        return ShimUtil.call(() -> ((Connection)this.connection).getClientID());
    }

    public void setClientID(String clientID) throws JMSException {
        ShimUtil.run(() -> this.connection.setClientID(clientID));
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((Connection)this.connection).getMetaData()));
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((Connection)this.connection).getExceptionListener()));
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        ShimUtil.run(() -> this.connection.setExceptionListener(JavaxJms.create(listener)));
    }

    public void start() throws JMSException {
        ShimUtil.run(() -> ((Connection)this.connection).start());
    }

    public void stop() throws JMSException {
        ShimUtil.run(() -> ((Connection)this.connection).stop());
    }

    public void close() throws JMSException {
        ShimUtil.run(() -> ((Connection)this.connection).close());
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        javax.jms.Destination javaxDestination = ShimUtil.destination(destination);
        javax.jms.ServerSessionPool javaxSessionPool = JavaxJms.create(sessionPool);
        return JakartaJms.create(ShimUtil.call(() -> this.connection.createConnectionConsumer(javaxDestination, messageSelector, javaxSessionPool, maxMessages)));
    }

    public ConnectionConsumer createSharedConnectionConsumer(jakarta.jms.Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        javax.jms.ServerSessionPool javaxSessionPool = JavaxJms.create(sessionPool);
        Topic javaxTopic = ShimUtil.topic(topic);
        return JakartaJms.create(ShimUtil.call(() -> this.connection.createSharedConnectionConsumer(javaxTopic, subscriptionName, messageSelector, javaxSessionPool, maxMessages)));
    }

    public ConnectionConsumer createDurableConnectionConsumer(jakarta.jms.Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        javax.jms.ServerSessionPool javaxSessionPool = JavaxJms.create(sessionPool);
        Topic javaxTopic = ShimUtil.topic(topic);
        return JakartaJms.create(ShimUtil.call(() -> this.connection.createDurableConnectionConsumer(javaxTopic, subscriptionName, messageSelector, javaxSessionPool, maxMessages)));
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(jakarta.jms.Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        javax.jms.ServerSessionPool javaxSessionPool = JavaxJms.create(sessionPool);
        Topic javaxTopic = ShimUtil.topic(topic);
        return JakartaJms.create(ShimUtil.call(() -> this.connection.createSharedDurableConnectionConsumer(javaxTopic, subscriptionName, messageSelector, javaxSessionPool, maxMessages)));
    }
}

