/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;

class JakartaConnectionFactory
implements ConnectionFactory {
    private final javax.jms.ConnectionFactory connectionFactory;

    JakartaConnectionFactory(javax.jms.ConnectionFactory connectionFactoryFactory) {
        this.connectionFactory = connectionFactoryFactory;
    }

    public Connection createConnection() throws JMSException {
        try {
            return JakartaJms.create(this.connectionFactory.createConnection());
        }
        catch (javax.jms.JMSException e) {
            JMSException jmsE = new JMSException(e.getMessage(), e.getErrorCode());
            jmsE.addSuppressed((Throwable)e);
            throw jmsE;
        }
    }

    public Connection createConnection(String username, String password) throws JMSException {
        try {
            return JakartaJms.create(this.connectionFactory.createConnection(username, password));
        }
        catch (javax.jms.JMSException e) {
            JMSException jmsE = new JMSException(e.getMessage(), e.getErrorCode());
            jmsE.addSuppressed((Throwable)e);
            throw jmsE;
        }
    }

    public JMSContext createContext() {
        return JakartaJms.create(this.connectionFactory.createContext());
    }

    public JMSContext createContext(String username, String password) {
        return JakartaJms.create(this.connectionFactory.createContext(username, password));
    }

    public JMSContext createContext(String username, String password, int sessionMode) {
        return JakartaJms.create(this.connectionFactory.createContext(username, password, sessionMode));
    }

    public JMSContext createContext(int sessionMode) {
        return JakartaJms.create(this.connectionFactory.createContext(sessionMode));
    }
}

