/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

class JakartaConsumer
implements JMSConsumer {
    private final javax.jms.JMSConsumer delegate;

    JakartaConsumer(javax.jms.JMSConsumer delegate) {
        this.delegate = delegate;
    }

    public String getMessageSelector() {
        return this.delegate.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        return JakartaJms.create(ShimUtil.callRuntime(() -> ((javax.jms.JMSConsumer)this.delegate).getMessageListener()));
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        ShimUtil.runRuntime(() -> this.delegate.setMessageListener(JavaxJms.create(listener)));
    }

    public Message receive() {
        return JakartaJms.create(this.delegate.receive());
    }

    public Message receive(long timeout) {
        return JakartaJms.create(this.delegate.receive(timeout));
    }

    public Message receiveNoWait() {
        return JakartaJms.create(this.delegate.receiveNoWait());
    }

    public void close() {
        this.delegate.close();
    }

    public <T> T receiveBody(Class<T> c) {
        return (T)this.delegate.receiveBody(c);
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        return (T)this.delegate.receiveBody(c, timeout);
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        return (T)this.delegate.receiveBodyNoWait(c);
    }
}

