/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import javax.jms.JMSContext;

class JakartaContext
implements jakarta.jms.JMSContext {
    private final JMSContext delegate;

    JakartaContext(JMSContext delegate) {
        this.delegate = delegate;
    }

    public jakarta.jms.JMSContext createContext(int sessionMode) {
        return JakartaJms.create(this.delegate.createContext(sessionMode));
    }

    public JMSProducer createProducer() {
        return JakartaJms.create(this.delegate.createProducer());
    }

    public String getClientID() {
        return this.delegate.getClientID();
    }

    public void setClientID(String clientID) {
        this.delegate.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() {
        return JakartaJms.create(this.delegate.getMetaData());
    }

    public ExceptionListener getExceptionListener() {
        return JakartaJms.create(this.delegate.getExceptionListener());
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.delegate.setExceptionListener(JavaxJms.create(listener));
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void setAutoStart(boolean autoStart) {
        this.delegate.setAutoStart(autoStart);
    }

    public boolean getAutoStart() {
        return this.delegate.getAutoStart();
    }

    public void close() {
        this.delegate.close();
    }

    public BytesMessage createBytesMessage() {
        return JakartaJms.create(this.delegate.createBytesMessage());
    }

    public MapMessage createMapMessage() {
        return JakartaJms.create(this.delegate.createMapMessage());
    }

    public Message createMessage() {
        return JakartaJms.create(this.delegate.createMessage());
    }

    public ObjectMessage createObjectMessage() {
        return JakartaJms.create(this.delegate.createObjectMessage());
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return JakartaJms.create(this.delegate.createObjectMessage(object));
    }

    public StreamMessage createStreamMessage() {
        return JakartaJms.create(this.delegate.createStreamMessage());
    }

    public TextMessage createTextMessage() {
        return JakartaJms.create(this.delegate.createTextMessage());
    }

    public TextMessage createTextMessage(String text) {
        return JakartaJms.create(this.delegate.createTextMessage(text));
    }

    public boolean getTransacted() {
        return this.delegate.getTransacted();
    }

    public int getSessionMode() {
        return this.delegate.getSessionMode();
    }

    public void commit() {
        this.delegate.commit();
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void recover() {
        this.delegate.recover();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return JakartaJms.create(this.delegate.createConsumer(ShimUtil.destination(destination)));
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return JakartaJms.create(this.delegate.createConsumer(ShimUtil.destination(destination), messageSelector));
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return JakartaJms.create(this.delegate.createConsumer(ShimUtil.destination(destination), messageSelector, noLocal));
    }

    public Queue createQueue(String queueName) {
        return JakartaJms.create(this.delegate.createQueue(queueName));
    }

    public Topic createTopic(String topicName) {
        return JakartaJms.create(this.delegate.createTopic(topicName));
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return JakartaJms.create(this.delegate.createDurableConsumer(ShimUtil.topic(topic), name));
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return JakartaJms.create(this.delegate.createDurableConsumer(ShimUtil.topic(topic), name, messageSelector, noLocal));
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return JakartaJms.create(this.delegate.createSharedDurableConsumer(ShimUtil.topic(topic), name));
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return JakartaJms.create(this.delegate.createSharedDurableConsumer(ShimUtil.topic(topic), name, messageSelector));
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return JakartaJms.create(this.delegate.createSharedConsumer(ShimUtil.topic(topic), sharedSubscriptionName));
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return JakartaJms.create(this.delegate.createSharedConsumer(ShimUtil.topic(topic), sharedSubscriptionName, messageSelector));
    }

    public QueueBrowser createBrowser(Queue queue) {
        return JakartaJms.create(this.delegate.createBrowser(ShimUtil.queue(queue)));
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return JakartaJms.create(this.delegate.createBrowser(ShimUtil.queue(queue), messageSelector));
    }

    public TemporaryQueue createTemporaryQueue() {
        return JakartaJms.create(this.delegate.createTemporaryQueue());
    }

    public TemporaryTopic createTemporaryTopic() {
        return JakartaJms.create(this.delegate.createTemporaryTopic());
    }

    public void unsubscribe(String name) {
        this.delegate.unsubscribe(name);
    }

    public void acknowledge() {
        this.delegate.acknowledge();
    }
}

