/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaMessage;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.JMSException;
import java.util.Enumeration;
import javax.jms.MapMessage;

class JakartaMapMessage
extends JakartaMessage
implements jakarta.jms.MapMessage {
    private final MapMessage delegate;

    JakartaMapMessage(MapMessage delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public boolean getBoolean(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getBoolean(name));
    }

    public byte getByte(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getByte(name));
    }

    public short getShort(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getShort(name));
    }

    public char getChar(String name) throws JMSException {
        return ShimUtil.call(() -> Character.valueOf(this.delegate.getChar(name))).charValue();
    }

    public int getInt(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getInt(name));
    }

    public long getLong(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getLong(name));
    }

    public float getFloat(String name) throws JMSException {
        return ShimUtil.call(() -> Float.valueOf(this.delegate.getFloat(name))).floatValue();
    }

    public double getDouble(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getDouble(name));
    }

    public String getString(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getString(name));
    }

    public byte[] getBytes(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getBytes(name));
    }

    public Object getObject(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getObject(name));
    }

    public Enumeration getMapNames() throws JMSException {
        return ShimUtil.call(() -> ((MapMessage)this.delegate).getMapNames());
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setBoolean(name, value));
    }

    public void setByte(String name, byte value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setByte(name, value));
    }

    public void setShort(String name, short value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setShort(name, value));
    }

    public void setChar(String name, char value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setChar(name, value));
    }

    public void setInt(String name, int value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setInt(name, value));
    }

    public void setLong(String name, long value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setLong(name, value));
    }

    public void setFloat(String name, float value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setFloat(name, value));
    }

    public void setDouble(String name, double value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setDouble(name, value));
    }

    public void setString(String name, String value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setString(name, value));
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setBytes(name, value));
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        ShimUtil.run(() -> this.delegate.setBytes(name, value, offset, length));
    }

    public void setObject(String name, Object value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setObject(name, value));
    }

    public boolean itemExists(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.itemExists(name));
    }
}

