/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JakartaWrapper;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.Enumeration;

class JakartaMessage<T extends javax.jms.Message>
implements Message,
JakartaWrapper<T> {
    private final T delegate;

    JakartaMessage(T delegate) {
        this.delegate = delegate;
    }

    public String getJMSMessageID() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSMessageID());
    }

    public void setJMSMessageID(String id) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSMessageID(id));
    }

    public long getJMSTimestamp() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSTimestamp());
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSTimestamp(timestamp));
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSCorrelationIDAsBytes());
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSCorrelationIDAsBytes(correlationID));
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSCorrelationID(correlationID));
    }

    public String getJMSCorrelationID() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSCorrelationID());
    }

    public Destination getJMSReplyTo() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.getJMSReplyTo()));
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSReplyTo(ShimUtil.destination(replyTo)));
    }

    public Destination getJMSDestination() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.getJMSDestination()));
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSDestination(ShimUtil.destination(destination)));
    }

    public int getJMSDeliveryMode() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSDeliveryMode());
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSDeliveryMode(deliveryMode));
    }

    public boolean getJMSRedelivered() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSRedelivered());
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSRedelivered(redelivered));
    }

    public String getJMSType() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSType());
    }

    public void setJMSType(String type) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSType(type));
    }

    public long getJMSExpiration() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSExpiration());
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSExpiration(expiration));
    }

    public long getJMSDeliveryTime() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSDeliveryTime());
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSDeliveryTime(deliveryTime));
    }

    public int getJMSPriority() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getJMSPriority());
    }

    public void setJMSPriority(int priority) throws JMSException {
        ShimUtil.run(() -> this.delegate.setJMSPriority(priority));
    }

    public void clearProperties() throws JMSException {
        ShimUtil.run(() -> this.delegate.clearProperties());
    }

    public boolean propertyExists(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.propertyExists(name));
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getBooleanProperty(name));
    }

    public byte getByteProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getByteProperty(name));
    }

    public short getShortProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getShortProperty(name));
    }

    public int getIntProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getIntProperty(name));
    }

    public long getLongProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getLongProperty(name));
    }

    public float getFloatProperty(String name) throws JMSException {
        return ShimUtil.call(() -> Float.valueOf(this.delegate.getFloatProperty(name))).floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getDoubleProperty(name));
    }

    public String getStringProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getStringProperty(name));
    }

    public Object getObjectProperty(String name) throws JMSException {
        return ShimUtil.call(() -> this.delegate.getObjectProperty(name));
    }

    public Enumeration getPropertyNames() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getPropertyNames());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setBooleanProperty(name, value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setByteProperty(name, value));
    }

    public void setShortProperty(String name, short value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setShortProperty(name, value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setIntProperty(name, value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setLongProperty(name, value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setFloatProperty(name, value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setDoubleProperty(name, value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setStringProperty(name, value));
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setObjectProperty(name, value));
    }

    public void acknowledge() throws JMSException {
        ShimUtil.run(() -> this.delegate.acknowledge());
    }

    public void clearBody() throws JMSException {
        ShimUtil.run(() -> this.delegate.clearBody());
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        return (T)ShimUtil.call(() -> this.delegate.getBody(c));
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return ShimUtil.call(() -> this.delegate.isBodyAssignableTo(c));
    }

    @Override
    public T unwrap() {
        return this.delegate;
    }
}

