/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import javax.jms.MessageConsumer;

class JakartaMessageConsumer
implements jakarta.jms.MessageConsumer {
    private final MessageConsumer delegate;

    JakartaMessageConsumer(MessageConsumer delegate) {
        this.delegate = delegate;
    }

    public String getMessageSelector() throws JMSException {
        return ShimUtil.call(() -> ((MessageConsumer)this.delegate).getMessageSelector());
    }

    public MessageListener getMessageListener() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((MessageConsumer)this.delegate).getMessageListener()));
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        ShimUtil.run(() -> this.delegate.setMessageListener(JavaxJms.create(listener)));
    }

    public Message receive() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((MessageConsumer)this.delegate).receive()));
    }

    public Message receive(long timeout) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.receive(timeout)));
    }

    public Message receiveNoWait() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((MessageConsumer)this.delegate).receiveNoWait()));
    }

    public void close() throws JMSException {
        ShimUtil.run(() -> ((MessageConsumer)this.delegate).close());
    }
}

