/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JakartaWrapper;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;

class JakartaMessageProducer<T extends javax.jms.MessageProducer>
implements MessageProducer,
JakartaWrapper<T> {
    private final T delegate;

    JakartaMessageProducer(T delegate) {
        this.delegate = delegate;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setDisableMessageID(value));
    }

    public boolean getDisableMessageID() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getDisableMessageID());
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        ShimUtil.run(() -> this.delegate.setDisableMessageTimestamp(value));
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getDisableMessageTimestamp());
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        ShimUtil.run(() -> this.delegate.setDeliveryMode(deliveryMode));
    }

    public int getDeliveryMode() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getDeliveryMode());
    }

    public void setPriority(int defaultPriority) throws JMSException {
        ShimUtil.run(() -> this.delegate.setPriority(defaultPriority));
    }

    public int getPriority() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getPriority());
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        ShimUtil.run(() -> this.delegate.setTimeToLive(timeToLive));
    }

    public long getTimeToLive() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getTimeToLive());
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        ShimUtil.run(() -> this.delegate.setDeliveryDelay(deliveryDelay));
    }

    public long getDeliveryDelay() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getDeliveryDelay());
    }

    public Destination getDestination() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.getDestination()));
    }

    public void close() throws JMSException {
        ShimUtil.run(() -> this.delegate.close());
    }

    public void send(Message message) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.message(message)));
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.message(message), deliveryMode, priority, timeToLive));
    }

    public void send(Destination destination, Message message) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.destination(destination), ShimUtil.message(message)));
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.destination(destination), ShimUtil.message(message), deliveryMode, priority, timeToLive));
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.message(message), JavaxJms.create(completionListener)));
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.message(message), deliveryMode, priority, timeToLive, JavaxJms.create(completionListener)));
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.destination(destination), ShimUtil.message(message), JavaxJms.create(completionListener)));
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        ShimUtil.run(() -> this.delegate.send(ShimUtil.destination(destination), ShimUtil.message(message), deliveryMode, priority, timeToLive, JavaxJms.create(completionListener)));
    }

    @Override
    public T unwrap() {
        return this.delegate;
    }
}

