/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JakartaWrapper;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSProducer;

class JakartaProducer<T extends JMSProducer>
implements jakarta.jms.JMSProducer,
JakartaWrapper<T> {
    private final T delegate;
    private CompletionListener completionListener;
    private javax.jms.CompletionListener javaxCompletionListener;

    JakartaProducer(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public T unwrap() {
        return this.delegate;
    }

    public jakarta.jms.JMSProducer send(Destination destination, Message message) {
        this.delegate.send(ShimUtil.destination(destination), ShimUtil.message(message));
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, String body) {
        this.delegate.send(ShimUtil.destination(destination), body);
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, Map<String, Object> body) {
        this.delegate.send(ShimUtil.destination(destination), body);
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, byte[] body) {
        this.delegate.send(ShimUtil.destination(destination), body);
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, Serializable body) {
        this.delegate.send(ShimUtil.destination(destination), body);
        return this;
    }

    public jakarta.jms.JMSProducer setDisableMessageID(boolean value) {
        this.delegate.setDisableMessageID(value);
        return this;
    }

    public boolean getDisableMessageID() {
        return this.delegate.getDisableMessageID();
    }

    public jakarta.jms.JMSProducer setDisableMessageTimestamp(boolean value) {
        this.delegate.setDisableMessageTimestamp(value);
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.delegate.getDisableMessageTimestamp();
    }

    public jakarta.jms.JMSProducer setDeliveryMode(int deliveryMode) {
        this.delegate.setDeliveryMode(deliveryMode);
        return this;
    }

    public int getDeliveryMode() {
        return this.delegate.getDeliveryMode();
    }

    public jakarta.jms.JMSProducer setPriority(int priority) {
        this.delegate.setPriority(priority);
        return this;
    }

    public int getPriority() {
        return this.delegate.getPriority();
    }

    public jakarta.jms.JMSProducer setTimeToLive(long timeToLive) {
        this.delegate.setTimeToLive(timeToLive);
        return this;
    }

    public long getTimeToLive() {
        return this.delegate.getTimeToLive();
    }

    public jakarta.jms.JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.delegate.setDeliveryDelay(deliveryDelay);
        return this;
    }

    public long getDeliveryDelay() {
        return this.delegate.getDeliveryDelay();
    }

    public jakarta.jms.JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        this.javaxCompletionListener = JavaxJms.create(completionListener);
        this.delegate.setAsync(this.javaxCompletionListener);
        return this;
    }

    public CompletionListener getAsync() {
        javax.jms.CompletionListener async = this.delegate.getAsync();
        if (async == this.javaxCompletionListener) {
            return this.completionListener;
        }
        return JakartaJms.create(async);
    }

    public jakarta.jms.JMSProducer setProperty(String name, boolean value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, byte value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, short value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, int value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, long value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, float value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, double value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, String value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, Object value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public jakarta.jms.JMSProducer clearProperties() {
        this.delegate.clearProperties();
        return this;
    }

    public boolean propertyExists(String name) {
        return this.delegate.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) {
        return this.delegate.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) {
        return this.delegate.getByteProperty(name);
    }

    public short getShortProperty(String name) {
        return this.delegate.getShortProperty(name);
    }

    public int getIntProperty(String name) {
        return this.delegate.getIntProperty(name);
    }

    public long getLongProperty(String name) {
        return this.delegate.getLongProperty(name);
    }

    public float getFloatProperty(String name) {
        return this.delegate.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) {
        return this.delegate.getDoubleProperty(name);
    }

    public String getStringProperty(String name) {
        return this.delegate.getStringProperty(name);
    }

    public Object getObjectProperty(String name) {
        return this.delegate.getObjectProperty(name);
    }

    public Set<String> getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    public jakarta.jms.JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.delegate.setJMSCorrelationIDAsBytes(correlationID);
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.delegate.getJMSCorrelationIDAsBytes();
    }

    public jakarta.jms.JMSProducer setJMSCorrelationID(String correlationID) {
        this.delegate.setJMSCorrelationID(correlationID);
        return this;
    }

    public String getJMSCorrelationID() {
        return this.delegate.getJMSCorrelationID();
    }

    public jakarta.jms.JMSProducer setJMSType(String type) {
        this.delegate.setJMSType(type);
        return this;
    }

    public String getJMSType() {
        return this.delegate.getJMSType();
    }

    public jakarta.jms.JMSProducer setJMSReplyTo(Destination replyTo) {
        this.delegate.setJMSReplyTo(ShimUtil.destination(replyTo));
        return this;
    }

    public Destination getJMSReplyTo() {
        return JakartaJms.create(this.delegate.getJMSReplyTo());
    }
}

