/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import java.util.Enumeration;
import javax.jms.Message;
import javax.jms.QueueBrowser;

class JakartaQueueBrowser
implements jakarta.jms.QueueBrowser {
    private final QueueBrowser delegate;

    JakartaQueueBrowser(QueueBrowser delegate) {
        this.delegate = delegate;
    }

    public Queue getQueue() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((QueueBrowser)this.delegate).getQueue()));
    }

    public String getMessageSelector() throws JMSException {
        return ShimUtil.call(() -> ((QueueBrowser)this.delegate).getMessageSelector());
    }

    public Enumeration getEnumeration() throws JMSException {
        final Enumeration original = ShimUtil.call(() -> ((QueueBrowser)this.delegate).getEnumeration());
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return original.hasMoreElements();
            }

            public Object nextElement() {
                return JakartaJms.create((Message)original.nextElement());
            }
        };
    }

    public void close() throws JMSException {
        ShimUtil.run(() -> ((QueueBrowser)this.delegate).close());
    }
}

